/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmCustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.NavigationProperty;
import org.apache.olingo.odata2.api.edm.provider.PropertyRef;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmNavigationPropertyImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmStructuralTypeImplProv;

public class EdmEntityTypeImplProv
extends EdmStructuralTypeImplProv
implements EdmEntityType {
    private EntityType entityType;
    private Map<String, EdmProperty> keyProperties;
    private List<EdmProperty> edmKeyProperties;
    private List<String> edmKeyPropertyNames;
    private Map<String, NavigationProperty> navigationProperties;
    private List<String> edmNavigationPropertyNames;

    public EdmEntityTypeImplProv(EdmImplProv edm, EntityType entityType, String namespace) throws EdmException {
        super(edm, (ComplexType)entityType, EdmTypeKind.ENTITY, namespace);
        this.entityType = entityType;
        this.buildNavigationPropertiesInternal();
    }

    private void buildNavigationPropertiesInternal() throws EdmException {
        this.navigationProperties = new HashMap<String, NavigationProperty>();
        if (this.entityType.getNavigationProperties() != null) {
            for (NavigationProperty navigationProperty : this.entityType.getNavigationProperties()) {
                this.navigationProperties.put(navigationProperty.getName(), navigationProperty);
            }
        }
    }

    public List<String> getKeyPropertyNames() throws EdmException {
        if (this.edmKeyPropertyNames == null) {
            if (this.edmBaseType != null) {
                return ((EdmEntityType)this.edmBaseType).getKeyPropertyNames();
            }
            this.edmKeyPropertyNames = new ArrayList<String>();
            if (this.entityType.getKey() != null) {
                for (PropertyRef keyProperty : this.entityType.getKey().getKeys()) {
                    this.edmKeyPropertyNames.add(keyProperty.getName());
                }
            } else {
                throw new EdmException(EdmException.COMMON);
            }
        }
        return this.edmKeyPropertyNames;
    }

    public List<EdmProperty> getKeyProperties() throws EdmException {
        if (this.edmKeyProperties == null) {
            if (this.edmBaseType != null) {
                return ((EdmEntityType)this.edmBaseType).getKeyProperties();
            }
            if (this.keyProperties == null) {
                this.keyProperties = new HashMap<String, EdmProperty>();
                this.edmKeyProperties = new ArrayList<EdmProperty>();
                for (String keyPropertyName : this.getKeyPropertyNames()) {
                    EdmTyped edmProperty = this.getProperty(keyPropertyName);
                    if (edmProperty != null && edmProperty instanceof EdmProperty) {
                        this.keyProperties.put(keyPropertyName, (EdmProperty)edmProperty);
                        this.edmKeyProperties.add((EdmProperty)edmProperty);
                        continue;
                    }
                    throw new EdmException(EdmException.COMMON);
                }
            }
        }
        return this.edmKeyProperties;
    }

    public boolean hasStream() throws EdmException {
        return this.entityType.isHasStream();
    }

    public EdmCustomizableFeedMappings getCustomizableFeedMappings() throws EdmException {
        return this.entityType.getCustomizableFeedMappings();
    }

    public List<String> getNavigationPropertyNames() throws EdmException {
        if (this.edmNavigationPropertyNames == null) {
            this.edmNavigationPropertyNames = new ArrayList<String>();
            if (this.edmBaseType != null) {
                this.edmNavigationPropertyNames.addAll(((EdmEntityType)this.edmBaseType).getNavigationPropertyNames());
            }
            if (this.entityType.getNavigationProperties() != null) {
                for (NavigationProperty navigationProperty : this.entityType.getNavigationProperties()) {
                    this.edmNavigationPropertyNames.add(navigationProperty.getName());
                }
            }
        }
        return this.edmNavigationPropertyNames;
    }

    public EdmEntityType getBaseType() throws EdmException {
        return (EdmEntityType)this.edmBaseType;
    }

    @Override
    protected EdmTyped getPropertyInternal(String name) throws EdmException {
        EdmTyped edmProperty = super.getPropertyInternal(name);
        if (edmProperty != null) {
            return edmProperty;
        }
        if (this.navigationProperties.containsKey(name)) {
            edmProperty = this.createNavigationProperty(this.navigationProperties.get(name));
            this.edmProperties.put(name, edmProperty);
        } else if (this.edmBaseType != null && (edmProperty = this.edmBaseType.getProperty(name)) != null) {
            this.edmProperties.put(name, edmProperty);
        }
        return edmProperty;
    }

    protected EdmTyped createNavigationProperty(NavigationProperty property) throws EdmException {
        return new EdmNavigationPropertyImplProv(this.edm, property);
    }

    public Map<String, NavigationProperty> getNavigationProperties() {
        return this.navigationProperties;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }
}

