/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;

public class EdmUtil {
    private static EdmTyped findProperty(EdmEntityType entityType, String name) throws EdmException {
        for (String item : entityType.getKeyPropertyNames()) {
            if (!item.equals(name)) continue;
            return entityType.getProperty(item);
        }
        return null;
    }

    public static List<EdmProperty> findOriginalKeys(EdmEntityType entityType) throws EdmException {
        LinkedList<EdmProperty> keys = new LinkedList<EdmProperty>();
        for (EdmProperty item : entityType.getKeyProperties()) {
            EdmSimplePropertyImplProv property = (EdmSimplePropertyImplProv)EdmUtil.findProperty(entityType, item.getName());
            if (property == null) continue;
            if (property.getComposite() != null) {
                keys.addAll(property.getComposite());
                continue;
            }
            keys.add(property);
        }
        return keys;
    }
}

