/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import org.apache.olingo.odata2.api.edm.EdmLiteralException;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataMessageException;
import org.apache.olingo.odata2.core.uri.expression.Token;
import org.apache.olingo.odata2.core.uri.expression.TokenKind;

public class TokenizerException
extends ODataMessageException {
    private static final long serialVersionUID = 77L;
    public static final MessageReference TYPEDECTECTION_FAILED_ON_STRING = TokenizerException.createMessageReference(TokenizerException.class, (String)"TYPEDECTECTION_FAILED_ON_STRING");
    public static final MessageReference UNKNOWN_CHARACTER = TokenizerException.createMessageReference(TokenizerException.class, (String)"UNKNOWN_CHARACTER");
    private Token token;
    private int position;

    public Token getToken() {
        return this.token;
    }

    public TokenizerException setToken(Token token) {
        this.token = token;
        return this;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public TokenizerException(MessageReference messageReference) {
        super(messageReference);
    }

    public TokenizerException(MessageReference messageReference, Throwable cause) {
        super(messageReference, cause);
    }

    public static TokenizerException createTYPEDECTECTION_FAILED_ON_STRING(EdmLiteralException ex, int position, String uriLiteral) {
        MessageReference msgRef = TYPEDECTECTION_FAILED_ON_STRING.create();
        msgRef.addContent(new Object[]{uriLiteral});
        msgRef.addContent(new Object[]{position});
        Token token = new Token(TokenKind.UNKNOWN, position, uriLiteral);
        return new TokenizerException(msgRef, (Throwable)ex).setToken(token);
    }

    public static TokenizerException createUNKNOWN_CHARACTER(int position, String uriLiteral, String expression) {
        MessageReference msgRef = UNKNOWN_CHARACTER.create();
        msgRef.addContent(new Object[]{uriLiteral});
        msgRef.addContent(new Object[]{position});
        msgRef.addContent(new Object[]{expression});
        Token token = new Token(TokenKind.UNKNOWN, position, uriLiteral);
        return new TokenizerException(msgRef).setToken(token);
    }
}

