/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.rest;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.processor.ODataErrorCallback;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.ep.ProviderFacadeImpl;
import org.apache.olingo.odata2.core.rest.ODataExceptionWrapper;
import org.apache.olingo.odata2.core.rest.ODataRootLocator;
import org.apache.olingo.odata2.core.rest.RestUtil;

@Provider
public class ODataExceptionMapperImpl
implements ExceptionMapper<Exception> {
    private static final String DOLLAR_FORMAT = "$format";
    private static final String DOLLAR_FORMAT_JSON = "json";
    private static final Locale DEFAULT_RESPONSE_LOCALE = Locale.ENGLISH;
    @Context
    UriInfo uriInfo;
    @Context
    HttpHeaders httpHeaders;
    @Context
    ServletConfig servletConfig;
    @Context
    HttpServletRequest servletRequest;
    @Context
    Application app;

    public Response toResponse(Exception exception) {
        ODataResponse response;
        try {
            response = exception instanceof WebApplicationException ? this.handleWebApplicationException(exception) : this.handleException(exception);
        }
        catch (Exception e) {
            response = ODataResponse.entity((Object)"Exception during error handling occured!").contentHeader(ContentType.TEXT_PLAIN.toContentTypeString()).status(HttpStatusCodes.INTERNAL_SERVER_ERROR).build();
        }
        return RestUtil.convertResponse(response);
    }

    private ODataResponse handleException(Exception exception) {
        ODataExceptionWrapper exceptionWrapper = new ODataExceptionWrapper(this.uriInfo, this.httpHeaders, this.getErrorHandlerCallback());
        return exceptionWrapper.wrapInExceptionResponse(exception);
    }

    private ODataResponse handleWebApplicationException(Exception exception) throws ClassNotFoundException, InstantiationException, IllegalAccessException, EntityProviderException {
        ODataErrorContext errorContext = this.createErrorContext((WebApplicationException)exception);
        ODataErrorCallback callback = this.getErrorHandlerCallback();
        return callback == null ? new ProviderFacadeImpl().writeErrorDocument(errorContext) : this.executeErrorCallback(errorContext, callback);
    }

    private ODataResponse executeErrorCallback(ODataErrorContext errorContext, ODataErrorCallback callback) {
        ODataResponse oDataResponse;
        try {
            oDataResponse = callback.handleError(errorContext);
        }
        catch (ODataApplicationException e) {
            oDataResponse = this.handleException((Exception)((Object)e));
        }
        return oDataResponse;
    }

    private ODataErrorContext createErrorContext(WebApplicationException exception) {
        ODataErrorContext context = new ODataErrorContext();
        if (this.uriInfo != null) {
            context.setRequestUri(this.uriInfo.getRequestUri());
        }
        if (this.httpHeaders != null && this.httpHeaders.getRequestHeaders() != null) {
            MultivaluedMap requestHeaders = this.httpHeaders.getRequestHeaders();
            Set entries = requestHeaders.entrySet();
            for (Map.Entry entry : entries) {
                context.putRequestHeader((String)entry.getKey(), (List)entry.getValue());
            }
        }
        context.setContentType(this.getContentType().toContentTypeString());
        context.setException((Exception)exception);
        context.setErrorCode(null);
        context.setMessage(exception.getMessage());
        context.setLocale(DEFAULT_RESPONSE_LOCALE);
        HttpStatusCodes statusCode = HttpStatusCodes.fromStatusCode((int)exception.getResponse().getStatus());
        context.setHttpStatus(statusCode);
        if (statusCode == HttpStatusCodes.METHOD_NOT_ALLOWED) {
            context.setHttpStatus(HttpStatusCodes.NOT_IMPLEMENTED);
            context.setMessage("The request dispatcher does not allow the HTTP method used for the request.");
            context.setLocale(Locale.ENGLISH);
        }
        return context;
    }

    private ContentType getContentType() {
        ContentType contentType = this.getContentTypeByUriInfo();
        if (contentType == null) {
            contentType = this.getContentTypeByAcceptHeader();
        }
        return contentType;
    }

    private ContentType getContentTypeByUriInfo() {
        MultivaluedMap queryParameters;
        ContentType contentType = null;
        if (this.uriInfo != null && this.uriInfo.getQueryParameters() != null && (queryParameters = this.uriInfo.getQueryParameters()).containsKey((Object)DOLLAR_FORMAT)) {
            String contentTypeString = (String)queryParameters.getFirst((Object)DOLLAR_FORMAT);
            contentType = DOLLAR_FORMAT_JSON.equals(contentTypeString) ? ContentType.APPLICATION_JSON : ContentType.APPLICATION_XML;
        }
        return contentType;
    }

    private ContentType getContentTypeByAcceptHeader() {
        for (MediaType type : this.httpHeaders.getAcceptableMediaTypes()) {
            if (!ContentType.isParseable(type.toString())) continue;
            ContentType convertedContentType = ContentType.create(type.toString());
            if (convertedContentType.isWildcard() || ContentType.APPLICATION_XML.equals(convertedContentType) || ContentType.APPLICATION_XML_CS_UTF_8.equals(convertedContentType) || ContentType.APPLICATION_ATOM_XML.equals(convertedContentType) || ContentType.APPLICATION_ATOM_XML_CS_UTF_8.equals(convertedContentType)) {
                return ContentType.APPLICATION_XML;
            }
            if (!ContentType.APPLICATION_JSON.equals(convertedContentType) && !ContentType.APPLICATION_JSON_CS_UTF_8.equals(convertedContentType)) continue;
            return ContentType.APPLICATION_JSON;
        }
        return ContentType.APPLICATION_XML;
    }

    private ODataErrorCallback getErrorHandlerCallback() {
        ODataServiceFactory serviceFactory = ODataRootLocator.createServiceFactoryFromContext(this.app, this.servletRequest, this.servletConfig);
        return (ODataErrorCallback)serviceFactory.getCallback(ODataErrorCallback.class);
    }
}

