/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.core.uri.expression.ExpressionParserInternalError;
import org.apache.olingo.odata2.core.uri.expression.ParameterSet;
import org.apache.olingo.odata2.core.uri.expression.ParameterSetCombination;

class InfoMethod {
    public MethodOperator method;
    public String syntax;
    public int minParameter;
    public int maxParameter;
    ParameterSetCombination combination;

    public InfoMethod(MethodOperator method, ParameterSetCombination combination) {
        this.method = method;
        this.syntax = method.toUriLiteral();
        this.minParameter = 1;
        this.maxParameter = 1;
        this.combination = combination;
    }

    public InfoMethod(MethodOperator method, int minParameters, int maxParameters, ParameterSetCombination combination) {
        this.method = method;
        this.syntax = method.toUriLiteral();
        this.minParameter = minParameters;
        this.maxParameter = maxParameters;
        this.combination = combination;
    }

    public InfoMethod(MethodOperator method, String string, int minParameters, int maxParameters, ParameterSetCombination combination) {
        this.method = method;
        this.syntax = string;
        this.minParameter = minParameters;
        this.maxParameter = maxParameters;
        this.combination = combination;
    }

    public MethodOperator getMethod() {
        return this.method;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public int getMinParameter() {
        return this.minParameter;
    }

    public int getMaxParameter() {
        return this.maxParameter;
    }

    public ParameterSet validateParameterSet(List<EdmType> actualParameterTypes) throws ExpressionParserInternalError {
        return this.combination.validate(actualParameterTypes);
    }

    public EdmType getReturnType() {
        return this.combination.getReturnType();
    }
}

