/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import com.google.gson.Gson;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;

public class EdmArray
extends AbstractSimpleType {
    private static final EdmArray INSTANCE = new EdmArray();

    public static EdmArray getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return String.class;
    }

    public final String valueToObjectKeyString(Object value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        if (value == null) {
            return null;
        }
        return this.internalValueToString(value, literalKind, facets);
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        if (returnType.isAssignableFrom(String.class)) {
            return returnType.cast(value);
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{returnType}));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        return value instanceof String ? (String)value : new Gson().toJson(value);
    }

    @Override
    public String toUriLiteral(String literal) throws EdmSimpleTypeException {
        return literal;
    }
}

