/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.UUID;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.EdmBinary;
import org.apache.olingo.odata2.core.edm.EdmBoolean;
import org.apache.olingo.odata2.core.edm.EdmByte;
import org.apache.olingo.odata2.core.edm.EdmDateTime;
import org.apache.olingo.odata2.core.edm.EdmDecimal;
import org.apache.olingo.odata2.core.edm.EdmDouble;
import org.apache.olingo.odata2.core.edm.EdmGuid;
import org.apache.olingo.odata2.core.edm.EdmInt16;
import org.apache.olingo.odata2.core.edm.EdmInt32;
import org.apache.olingo.odata2.core.edm.EdmInt64;
import org.apache.olingo.odata2.core.edm.EdmSingle;
import org.apache.olingo.odata2.core.edm.EdmString;
import org.apache.olingo.odata2.core.edm.EdmTime;

public class EdmAuto
extends AbstractSimpleType {
    private static final EdmAuto instance = new EdmAuto();
    private EdmString internal = new EdmString();

    public static EdmAuto getInstance() {
        return instance;
    }

    public EdmSimpleType getType(Object value) {
        if (value == null) {
            return EdmString.getInstance();
        }
        Class<?> jpaType = value.getClass();
        if (jpaType.equals(String.class) || jpaType.equals(Character.class) || jpaType.equals(Character.TYPE) || jpaType.equals(char[].class) || jpaType.equals(Character[].class)) {
            return EdmString.getInstance();
        }
        if (jpaType.equals(Long.class) || jpaType.equals(Long.TYPE)) {
            return EdmInt64.getInstance();
        }
        if (jpaType.equals(Short.class) || jpaType.equals(Short.TYPE)) {
            return EdmInt16.getInstance();
        }
        if (jpaType.equals(Integer.class) || jpaType.equals(Integer.TYPE)) {
            return EdmInt32.getInstance();
        }
        if (jpaType.equals(Double.class) || jpaType.equals(Double.TYPE)) {
            return EdmDouble.getInstance();
        }
        if (jpaType.equals(Float.class) || jpaType.equals(Float.TYPE)) {
            return EdmSingle.getInstance();
        }
        if (jpaType.equals(BigDecimal.class)) {
            return EdmDecimal.getInstance();
        }
        if (jpaType.equals(byte[].class)) {
            return EdmString.getInstance();
        }
        if (jpaType.equals(Byte.class) || jpaType.equals(Byte.TYPE)) {
            return EdmByte.getInstance();
        }
        if (jpaType.equals(Boolean.class) || jpaType.equals(Boolean.TYPE)) {
            return EdmBoolean.getInstance();
        }
        if (jpaType.equals(Time.class)) {
            return EdmTime.getInstance();
        }
        if (jpaType.equals(Date.class) || value instanceof Calendar || jpaType.equals(Timestamp.class) || jpaType.equals(java.util.Date.class)) {
            return EdmDateTime.getInstance();
        }
        if (jpaType.equals(UUID.class)) {
            return EdmGuid.getInstance();
        }
        if (jpaType.equals(Byte[].class)) {
            return EdmBinary.getInstance();
        }
        if (jpaType.equals(Blob.class)) {
            return EdmBinary.getInstance();
        }
        if (jpaType.equals(Clob.class)) {
            return EdmString.getInstance();
        }
        if (jpaType.isEnum()) {
            return EdmString.getInstance();
        }
        return EdmString.getInstance();
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        return this.internal.internalValueOfString(value, literalKind, facets, returnType);
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        return this.internal.internalValueToString(value, literalKind, facets);
    }

    public Class<?> getDefaultType() {
        return this.internal.getDefaultType();
    }
}

