/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.Bit;
import org.apache.olingo.odata2.core.edm.Uint7;

public class EdmSByte
extends AbstractSimpleType {
    private static final EdmSByte instance = new EdmSByte();

    public static EdmSByte getInstance() {
        return instance;
    }

    @Override
    public boolean isCompatible(EdmSimpleType simpleType) {
        return simpleType instanceof Bit || simpleType instanceof Uint7 || simpleType instanceof EdmSByte;
    }

    public Class<?> getDefaultType() {
        return Byte.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        Byte valueByte;
        try {
            valueByte = Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(new Object[]{value}), (Throwable)e);
        }
        if (returnType.isAssignableFrom(Byte.class)) {
            return returnType.cast(valueByte);
        }
        if (returnType.isAssignableFrom(Short.class)) {
            return returnType.cast(valueByte.shortValue());
        }
        if (returnType.isAssignableFrom(Integer.class)) {
            return returnType.cast(valueByte.intValue());
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(valueByte.longValue());
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{returnType}));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        if (value instanceof Byte) {
            return value.toString();
        }
        if (value instanceof Short || value instanceof Integer || value instanceof Long) {
            if (((Number)value).longValue() >= -128L && ((Number)value).longValue() <= 127L) {
                return value.toString();
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_ILLEGAL_CONTENT.addContent(new Object[]{value}));
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{value.getClass()}));
    }
}

