/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import org.springframework.social.facebook.api.CoverPhoto;
import org.springframework.social.facebook.api.Event;
import org.springframework.social.facebook.api.Group;
import org.springframework.social.facebook.api.Location;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.impl.json.FacebookObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class EventMixin
extends FacebookObjectMixin {
    @JsonProperty(value="id")
    String id;
    @JsonProperty(value="cover")
    CoverPhoto cover;
    @JsonProperty(value="description")
    String description;
    @JsonProperty(value="end_time")
    Date endTime;
    @JsonProperty(value="is_date_only")
    boolean isDateOnly;
    @JsonProperty(value="location")
    String location;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="owner")
    Reference owner;
    @JsonProperty(value="parent_group")
    Group parentGroup;
    @JsonProperty(value="privacy")
    @JsonDeserialize(using=PrivacyDeserializer.class)
    Event.Privacy privacy;
    @JsonProperty(value="start_time")
    Date startTime;
    @JsonProperty(value="ticket_uri")
    String ticketUri;
    @JsonProperty(value="timezone")
    String timeZone;
    @JsonProperty(value="updated_time")
    Date updatedTime;
    @JsonProperty(value="venue")
    Location venue;

    EventMixin() {
    }

    private static class PrivacyDeserializer
    extends JsonDeserializer<Event.Privacy> {
        private PrivacyDeserializer() {
        }

        public Event.Privacy deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Event.Privacy.valueOf(jp.getText().toUpperCase());
        }
    }
}

