/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.plus;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.social.google.api.ApiEntity;
import org.springframework.social.google.api.plus.AgeRange;
import org.springframework.social.google.api.plus.Organization;
import org.springframework.social.google.api.plus.ProfileUrl;
import org.springframework.social.google.api.plus.impl.AgeRangeDeserializer;

public class Person
extends ApiEntity {
    @JsonProperty
    private Name name;
    private String displayName;
    private String url;
    @JsonProperty(value="isPlusUser")
    private boolean plusUser;
    private int circledByCount;
    @JsonProperty
    private Image image;
    private String thumbnailUrl;
    private Date birthday;
    private String gender;
    private String occupation;
    private String aboutMe;
    private String tagline;
    private String nickname;
    private String language;
    private Boolean verified = false;
    private String relationshipStatus;
    private List<ProfileUrl> urls;
    private List<Organization> organizations;
    private Map<String, Boolean> placesLived;
    private Map<String, String> emails;
    @JsonProperty
    @JsonDeserialize(using=AgeRangeDeserializer.class)
    private AgeRange ageRange = AgeRange.UNKNOWN;

    public String toString() {
        return this.displayName;
    }

    public String getGivenName() {
        return this.name == null ? null : this.name.givenName;
    }

    public String getFamilyName() {
        return this.name == null ? null : this.name.familyName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isPlusUser() {
        return this.plusUser;
    }

    public int getCircledByCount() {
        return this.circledByCount;
    }

    public String getImageUrl() {
        if (this.thumbnailUrl != null) {
            return this.thumbnailUrl;
        }
        if (this.image != null) {
            return this.image.url;
        }
        return null;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public String getGender() {
        return this.gender;
    }

    public String getOccupation() {
        return this.occupation;
    }

    public String getAboutMe() {
        return this.aboutMe;
    }

    public String getTagline() {
        return this.tagline;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getLanguage() {
        return this.language;
    }

    public Boolean isVerified() {
        return this.verified;
    }

    public String getRelationshipStatus() {
        return this.relationshipStatus;
    }

    public List<ProfileUrl> getUrls() {
        return this.urls;
    }

    public List<Organization> getOrganizations() {
        return this.organizations;
    }

    public Map<String, Boolean> getPlacesLived() {
        return this.placesLived;
    }

    @JsonSetter
    private void setPlacesLived(List<PlaceLived> placesLivedAsList) {
        this.placesLived = new LinkedHashMap<String, Boolean>();
        if (placesLivedAsList != null) {
            for (PlaceLived placeLived : placesLivedAsList) {
                this.placesLived.put(placeLived.value, placeLived.primary);
            }
        }
    }

    public Map<String, String> getEmails() {
        return this.emails;
    }

    @JsonSetter
    private void setEmails(List<Email> emailsAsList) {
        this.emails = new LinkedHashMap<String, String>();
        if (emailsAsList != null) {
            for (Email email : emailsAsList) {
                this.emails.put(email.value, email.type);
            }
        }
    }

    public Set<String> getEmailAddresses() {
        return this.emails == null ? null : this.emails.keySet();
    }

    public String getAccountEmail() {
        if (this.emails != null) {
            for (Map.Entry<String, String> entry : this.emails.entrySet()) {
                if (!entry.getValue().equalsIgnoreCase("account")) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public AgeRange getAgeRange() {
        return this.ageRange;
    }

    private static class Email {
        @JsonProperty
        private String value;
        @JsonProperty
        private String type;

        private Email() {
        }
    }

    private static class PlaceLived {
        @JsonProperty
        private String value;
        @JsonProperty
        private boolean primary;

        private PlaceLived() {
        }
    }

    private static class Image {
        @JsonProperty
        private String url;

        private Image() {
        }
    }

    private static class Name {
        @JsonProperty
        private String givenName;
        @JsonProperty
        private String familyName;

        private Name() {
        }
    }
}

