/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.drive;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.social.google.api.drive.AdditionalRole;
import org.springframework.social.google.api.drive.DriveUser;
import org.springframework.social.google.api.drive.PermissionRole;

public class DriveAbout {
    private String name;
    private long quotaBytesTotal;
    private long quotaBytesUsed;
    private long quotaBytesUsedInTrash;
    private long largestChangeId;
    private long remainingChangeIds;
    private String rootFolderId;
    private String domainSharingPolicy;
    private List<FormatMapping> importFormats;
    private List<FormatMapping> exportFormats;
    private List<RoleInfo> additionalRoleInfo;
    private Map<String, Double> features;
    private Map<String, Long> maxUploadSizes;
    private String permissionId;
    @JsonProperty(value="isCurrentAppInstalled")
    private boolean currentAppInstalled;
    private String languageCode;
    private DriveUser user;
    private long quotaBytesUsedAggregate;

    public String getName() {
        return this.name;
    }

    public long getQuotaBytesTotal() {
        return this.quotaBytesTotal;
    }

    public long getQuotaBytesUsed() {
        return this.quotaBytesUsed;
    }

    public long getQuotaBytesUsedInTrash() {
        return this.quotaBytesUsedInTrash;
    }

    public long getLargestChangeId() {
        return this.largestChangeId;
    }

    public long getRemainingChangeIds() {
        return this.remainingChangeIds;
    }

    public String getRootFolderId() {
        return this.rootFolderId;
    }

    public String getDomainSharingPolicy() {
        return this.domainSharingPolicy;
    }

    public List<FormatMapping> getImportFormats() {
        return this.importFormats;
    }

    public List<FormatMapping> getExportFormats() {
        return this.exportFormats;
    }

    public List<RoleInfo> getAdditionalRoleInfo() {
        return this.additionalRoleInfo;
    }

    public Map<String, Double> getFeatures() {
        return this.features;
    }

    @JsonSetter
    private void setFeatures(List<Feature> featuresAsList) {
        this.features = new HashMap<String, Double>();
        for (Feature feature : featuresAsList) {
            this.features.put(feature.featureName, feature.featureRate);
        }
    }

    public Map<String, Long> getMaxUploadSizes() {
        return this.maxUploadSizes;
    }

    @JsonSetter
    private void setMaxUploadSizes(List<MaxUploadSize> maxUploadSizesAsList) {
        this.maxUploadSizes = new HashMap<String, Long>();
        for (MaxUploadSize maxUploadSize : maxUploadSizesAsList) {
            this.maxUploadSizes.put(maxUploadSize.type, maxUploadSize.size);
        }
    }

    public String getPermissionId() {
        return this.permissionId;
    }

    public boolean isCurrentAppInstalled() {
        return this.currentAppInstalled;
    }

    public DriveUser getUser() {
        return this.user;
    }

    public long getQuotaBytesUsedAggregate() {
        return this.quotaBytesUsedAggregate;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    private static class MaxUploadSize {
        @JsonProperty
        String type;
        @JsonProperty
        Long size;

        private MaxUploadSize() {
        }
    }

    private static class Feature {
        @JsonProperty
        String featureName;
        @JsonProperty
        Double featureRate;

        private Feature() {
        }
    }

    public static class RoleInfo {
        @JsonProperty
        private String type;
        @JsonProperty
        private List<RoleSet> roleSets;

        public String getType() {
            return this.type;
        }

        public List<RoleSet> getRoleSets() {
            return this.roleSets;
        }
    }

    public static class RoleSet {
        @JsonProperty
        private PermissionRole primaryRole;
        @JsonProperty
        private List<AdditionalRole> additionalRoles;

        public PermissionRole getPrimaryRole() {
            return this.primaryRole;
        }

        public List<AdditionalRole> getAdditionalRoles() {
            return this.additionalRoles;
        }
    }

    public static class FormatMapping {
        @JsonProperty
        private String source;
        @JsonProperty
        private List<String> targets;

        public String getSource() {
            return this.source;
        }

        public List<String> getTargets() {
            return this.targets;
        }
    }
}

