/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.drive;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.social.google.api.ApiEntity;
import org.springframework.social.google.api.drive.CommentReply;
import org.springframework.social.google.api.drive.CommentStatus;
import org.springframework.social.google.api.drive.DriveUser;

public class FileComment
extends ApiEntity {
    private Date createdDate;
    private Date modifiedDate;
    private DriveUser author;
    private String htmlContent;
    private String content;
    private boolean deleted;
    private CommentStatus status;
    @JsonProperty
    private CommentContext context;
    private List<CommentReply> replies;

    public FileComment() {
    }

    public FileComment(String content) {
        this.content = content;
    }

    public FileComment(String content, MediaType contextType, String contextValue) {
        this(content, contextType.toString(), contextValue);
    }

    public FileComment(String content, String contextType, String contextValue) {
        this(content);
        this.context = new CommentContext();
        this.context.type = contextType;
        this.context.value = contextValue;
    }

    @Override
    @JsonProperty(value="commentId")
    public String getId() {
        return super.getId();
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public DriveUser getAuthor() {
        return this.author;
    }

    public String getHtmlContent() {
        return this.htmlContent;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public CommentStatus getStatus() {
        return this.status;
    }

    public CommentContext getContext() {
        return this.context;
    }

    public List<CommentReply> getReplies() {
        return this.replies;
    }

    private static class CommentContext {
        @JsonProperty
        private String type;
        @JsonProperty
        private String value;

        private CommentContext() {
        }
    }
}

