/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Unsubscribed
implements IMessage {
    public static final int MESSAGE_TYPE = 35;
    private static final long SUBSCRIPTION_NULL = -1L;
    public final long request;
    public final long subscription;
    public final String reason;

    public Unsubscribed(long request, long subscription, String reason) {
        this.request = request;
        this.subscription = subscription;
        this.reason = reason;
    }

    public static Unsubscribed parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 35, "UNSUBSCRIBED", 2, 3);
        long request = MessageUtil.parseLong(wmsg.get(1));
        long subscription = -1L;
        String reason = null;
        if (wmsg.size() > 2) {
            Map details = (Map)wmsg.get(2);
            if (details.containsKey("subscription")) {
                subscription = MessageUtil.parseLong(details.get("subscription"));
            }
            if (details.containsKey("reason")) {
                reason = (String)details.get("reason");
            }
        }
        return new Unsubscribed(request, subscription, reason);
    }

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(35);
        marshaled.add(this.request);
        if (this.subscription != -1L || this.reason != null) {
            HashMap<String, Object> details = new HashMap<String, Object>();
            if (this.reason != null) {
                details.put("reason", this.reason);
            }
            if (this.subscription != -1L) {
                details.put("subscription", this.subscription);
            }
            marshaled.add(details);
        }
        return marshaled;
    }
}

