/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.reflectionRoles;

import io.crossbar.autobahn.wamp.Session;
import io.crossbar.autobahn.wamp.interfaces.ISerializer;
import io.crossbar.autobahn.wamp.reflectionRoles.CalleeProxyInvocationHandler;
import io.crossbar.autobahn.wamp.reflectionRoles.MethodEventHandler;
import io.crossbar.autobahn.wamp.reflectionRoles.MethodInvocationHandler;
import io.crossbar.autobahn.wamp.reflectionRoles.WampProcedure;
import io.crossbar.autobahn.wamp.reflectionRoles.WampTopic;
import io.crossbar.autobahn.wamp.types.Registration;
import io.crossbar.autobahn.wamp.types.Subscription;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java8.util.concurrent.CompletableFuture;

public class ReflectionServices {
    private final Session mSession;
    private final ISerializer mSerializer;

    public ReflectionServices(Session session, ISerializer serializer) {
        this.mSession = session;
        this.mSerializer = serializer;
    }

    public List<CompletableFuture<Registration>> registerCallee(Object instance) {
        ArrayList<CompletableFuture<Registration>> registrations = new ArrayList<CompletableFuture<Registration>>();
        Class<?> classType = instance.getClass();
        for (Method method : classType.getMethods()) {
            if (!method.isAnnotationPresent(WampProcedure.class)) continue;
            CompletableFuture<Registration> currentRegistration = this.RegisterSingleMethod(instance, method);
            registrations.add(currentRegistration);
        }
        for (GenericDeclaration genericDeclaration : classType.getInterfaces()) {
            for (Method method : ((Class)genericDeclaration).getMethods()) {
                if (!method.isAnnotationPresent(WampProcedure.class)) continue;
                CompletableFuture<Registration> currentRegistration = this.RegisterSingleMethod(instance, method);
                registrations.add(currentRegistration);
            }
        }
        return registrations;
    }

    private CompletableFuture<Registration> RegisterSingleMethod(Object instance, Method method) {
        WampProcedure anotation = method.getAnnotation(WampProcedure.class);
        MethodInvocationHandler currentMethodHandler = new MethodInvocationHandler(instance, method, this.mSerializer);
        return this.mSession.register(anotation.value(), currentMethodHandler);
    }

    public List<CompletableFuture<Subscription>> registerSubscriber(Object instance) {
        ArrayList<CompletableFuture<Subscription>> subscriptions = new ArrayList<CompletableFuture<Subscription>>();
        Class<?> classType = instance.getClass();
        for (Method method : classType.getMethods()) {
            if (!method.isAnnotationPresent(WampTopic.class)) continue;
            CompletableFuture<Subscription> currentSubscription = this.singleSubscribe(instance, method);
            subscriptions.add(currentSubscription);
        }
        for (GenericDeclaration genericDeclaration : classType.getInterfaces()) {
            for (Method method : ((Class)genericDeclaration).getMethods()) {
                if (!method.isAnnotationPresent(WampTopic.class)) continue;
                CompletableFuture<Subscription> currentSubscription = this.singleSubscribe(instance, method);
                subscriptions.add(currentSubscription);
            }
        }
        return subscriptions;
    }

    private CompletableFuture<Subscription> singleSubscribe(Object instance, Method method) {
        WampTopic anotation = method.getAnnotation(WampTopic.class);
        MethodEventHandler currentMethodHandler = new MethodEventHandler(instance, method, this.mSerializer);
        return this.mSession.subscribe(anotation.value(), currentMethodHandler);
    }

    public <TProxy> TProxy getCalleeProxy(Class<TProxy> proxyClass) {
        Object result = Proxy.newProxyInstance(proxyClass.getClassLoader(), new Class[]{proxyClass}, (InvocationHandler)new CalleeProxyInvocationHandler(this.mSession));
        return (TProxy)result;
    }
}

