/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.transports;

import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import io.crossbar.autobahn.wamp.interfaces.ISerializer;
import io.crossbar.autobahn.wamp.interfaces.ITransport;
import io.crossbar.autobahn.wamp.interfaces.ITransportHandler;
import io.crossbar.autobahn.wamp.serializers.CBORSerializer;
import io.crossbar.autobahn.wamp.serializers.JSONSerializer;
import io.crossbar.autobahn.wamp.serializers.MessagePackSerializer;
import io.crossbar.autobahn.wamp.types.CloseDetails;
import io.crossbar.autobahn.wamp.types.TransportOptions;
import io.crossbar.autobahn.websocket.WebSocketConnection;
import io.crossbar.autobahn.websocket.WebSocketConnectionHandler;
import io.crossbar.autobahn.websocket.types.ConnectionResponse;
import io.crossbar.autobahn.websocket.types.WebSocketOptions;
import java.util.List;

public class AndroidWebSocket
implements ITransport {
    public static final IABLogger LOGGER = ABLogger.getLogger(AndroidWebSocket.class.getName());
    private static final String[] SERIALIZERS_DEFAULT = new String[]{"wamp.2.cbor", "wamp.2.msgpack", "wamp.2.json"};
    private final WebSocketConnection mConnection;
    private final String mUri;
    private List<String> mSerializers;
    private ISerializer mSerializer;

    public AndroidWebSocket(String uri) {
        this.mUri = uri;
        this.mConnection = new WebSocketConnection();
    }

    public AndroidWebSocket(String uri, List<String> serializers) {
        this(uri);
        this.mSerializers = serializers;
    }

    private String[] getSerializers() {
        if (this.mSerializers != null) {
            return (String[])this.mSerializers.toArray();
        }
        return SERIALIZERS_DEFAULT;
    }

    @Override
    public void send(byte[] payload, boolean isBinary) {
        this.mConnection.sendMessage(payload, isBinary);
    }

    @Override
    public void connect(ITransportHandler transportHandler) throws Exception {
        this.connect(transportHandler, new TransportOptions());
    }

    @Override
    public void connect(final ITransportHandler transportHandler, TransportOptions options) throws Exception {
        WebSocketOptions webSocketOptions = new WebSocketOptions();
        webSocketOptions.setAutoPingInterval(options.getAutoPingInterval());
        webSocketOptions.setAutoPingTimeout(options.getAutoPingTimeout());
        webSocketOptions.setMaxFramePayloadSize(options.getMaxFramePayloadSize());
        this.mConnection.connect(this.mUri, this.getSerializers(), new WebSocketConnectionHandler(){

            @Override
            public void onConnect(ConnectionResponse response) {
                LOGGER.d(String.format("Negotiated serializer=%s", response.protocol));
                try {
                    AndroidWebSocket.this.mSerializer = AndroidWebSocket.this.initializeSerializer(response.protocol);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onOpen() {
                try {
                    transportHandler.onConnect(AndroidWebSocket.this, AndroidWebSocket.this.mSerializer);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onClose(int code, String reason) {
                String closeReason = code == 3 ? "wamp.close.transport_lost" : "wamp.close.normal";
                transportHandler.onLeave(new CloseDetails(closeReason, null));
                LOGGER.d(String.format("Disconnected, code=%s, reasons=%s", code, reason));
                transportHandler.onDisconnect(code == 1 || code == 1000);
            }

            @Override
            public void onMessage(String payload) {
                try {
                    transportHandler.onMessage(payload.getBytes(), false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onMessage(byte[] payload, boolean isBinary) {
                try {
                    transportHandler.onMessage(payload, isBinary);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, webSocketOptions, null);
    }

    @Override
    public boolean isOpen() {
        return this.mConnection.isConnected();
    }

    @Override
    public void close() throws Exception {
        this.mConnection.sendClose();
    }

    @Override
    public void abort() throws Exception {
        this.mConnection.sendClose();
    }

    @Override
    public void setOptions(TransportOptions options) {
        WebSocketOptions webSocketOptions = new WebSocketOptions();
        webSocketOptions.setAutoPingTimeout(options.getAutoPingTimeout());
        webSocketOptions.setAutoPingInterval(options.getAutoPingInterval());
        this.mConnection.setOptions(webSocketOptions);
    }

    private ISerializer initializeSerializer(String negotiatedSerializer) throws Exception {
        switch (negotiatedSerializer) {
            case "wamp.2.cbor": {
                return new CBORSerializer();
            }
            case "wamp.2.json": {
                return new JSONSerializer();
            }
            case "wamp.2.msgpack": {
                return new MessagePackSerializer();
            }
        }
        throw new IllegalArgumentException("Unsupported serializer.");
    }
}

