/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import io.crossbar.autobahn.wamp.utils.Shortcuts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Hello
implements IMessage {
    public static final int MESSAGE_TYPE = 1;
    public final String realm;
    public final Map<String, Map> roles;
    public final List<String> authMethods;
    public final String authID;
    public final String authRole;
    public final Map<String, Object> authextra;

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(1);
        marshaled.add(this.realm);
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("roles", this.roles);
        if (this.authMethods != null) {
            details.put("authmethods", this.authMethods);
        }
        if (this.authID != null) {
            details.put("authid", this.authID);
        }
        if (this.authRole != null) {
            details.put("authrole", this.authRole);
        }
        if (this.authextra != null) {
            details.put("authextra", this.authextra);
        }
        marshaled.add(details);
        return marshaled;
    }

    public static Hello parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 1, "HELLO", 3);
        String realm = (String)wmsg.get(1);
        Map details = (Map)wmsg.get(2);
        Map roles = (Map)details.get("roles");
        List authMethods = Shortcuts.getOrDefault(details, "authmethods", null);
        String authID = Shortcuts.getOrDefault(details, "authid", null);
        String authRole = Shortcuts.getOrDefault(details, "authrole", null);
        Map authextra = Shortcuts.getOrDefault(details, "authextra", null);
        return new Hello(realm, roles, authMethods, authID, authRole, authextra);
    }

    public Hello(String realm, Map<String, Map> roles) {
        this(realm, roles, null, null, null, null);
    }

    @Deprecated
    public Hello(String realm, Map<String, Map> roles, List<String> authMethods, String authID, Map<String, Object> authextra) {
        this(realm, roles, authMethods, authID, null, authextra);
    }

    public Hello(String realm, Map<String, Map> roles, List<String> authMethods, String authID, String authRole, Map<String, Object> authextra) {
        this.realm = realm;
        this.roles = roles;
        this.authMethods = authMethods;
        this.authID = authID;
        this.authRole = authRole;
        this.authextra = authextra;
    }
}

