/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.exceptions.ProtocolError;
import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Result
implements IMessage {
    public static final int MESSAGE_TYPE = 50;
    public final long request;
    public final List<Object> args;
    public final Map<String, Object> kwargs;

    public Result(long request, List<Object> args, Map<String, Object> kwargs) {
        this.request = request;
        this.args = args;
        this.kwargs = kwargs;
    }

    public static Result parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 50, "RESULT", 4, 6);
        long request = MessageUtil.parseLong(wmsg.get(1));
        List args = null;
        if (wmsg.size() > 3) {
            if (wmsg.get(3) instanceof byte[]) {
                throw new ProtocolError("Binary payload not supported");
            }
            args = (List)wmsg.get(3);
        }
        Map kwargs = null;
        if (wmsg.size() > 4) {
            kwargs = (Map)wmsg.get(4);
        }
        return new Result(request, args, kwargs);
    }

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(50);
        marshaled.add(this.request);
        marshaled.add(Collections.emptyMap());
        if (this.kwargs != null) {
            if (this.args == null) {
                marshaled.add(Collections.emptyList());
            } else {
                marshaled.add(this.args);
            }
            marshaled.add(this.kwargs);
        } else if (this.args != null) {
            marshaled.add(this.args);
        }
        return marshaled;
    }
}

