/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.utils;

import io.crossbar.autobahn.wamp.utils.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthUtil {
    private static final String SSH_BEGIN = "-----BEGIN OPENSSH PRIVATE KEY-----";
    private static final String SSH_END = "-----END OPENSSH PRIVATE KEY-----";
    private static final String OPENSSH_KEY_V1 = "openssh-key-v1";

    private static Class getBase64ClassAndroid() {
        try {
            return Class.forName("android.util.Base64");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class getBase64ClassJava8() {
        try {
            return Class.forName("java.util.Base64");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toBinary(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String toHexString(byte[] buf) {
        Formatter formatter = new Formatter();
        for (byte b : buf) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    public static byte[] decodeString(String privateKey) throws Exception {
        if (Platform.isAndroid()) {
            Class base64Class = AuthUtil.getBase64ClassAndroid();
            Method method = base64Class.getMethod("decode", String.class, Integer.TYPE);
            Field field = base64Class.getField("DEFAULT");
            return (byte[])method.invoke(null, privateKey, field.getInt(base64Class));
        }
        Class base64Class = AuthUtil.getBase64ClassJava8();
        Object encoderObject = base64Class.getMethod("getDecoder", new Class[0]).invoke(null, new Object[0]);
        return (byte[])encoderObject.getClass().getMethod("decode", String.class).invoke(encoderObject, privateKey);
    }

    public static String encodeToString(byte[] challenge) throws Exception {
        if (Platform.isAndroid()) {
            Class base64Class = AuthUtil.getBase64ClassAndroid();
            Method method = base64Class.getMethod("encodeToString", byte[].class, Integer.TYPE);
            Field field = base64Class.getField("DEFAULT");
            String result = (String)method.invoke(null, challenge, field.getInt(base64Class));
            return result.trim();
        }
        Class base64Class = AuthUtil.getBase64ClassJava8();
        Object encoderObject = base64Class.getMethod("getEncoder", new Class[0]).invoke(null, new Object[0]);
        String result = (String)encoderObject.getClass().getMethod("encodeToString", byte[].class).invoke(encoderObject, new Object[]{challenge});
        return result.trim();
    }

    public static Map<String, byte[]> parseOpenSSHFile(File file) throws Exception {
        String sCurrentLine;
        BufferedReader br = new BufferedReader(new FileReader(file));
        ArrayList<String> lines = new ArrayList<String>();
        while ((sCurrentLine = br.readLine()) != null) {
            lines.add(sCurrentLine);
        }
        return AuthUtil.parseOpenSSHFile(lines);
    }

    private static Map<String, byte[]> parseOpenSSHFile(List<String> lines) throws Exception {
        if (!lines.get(0).equals(SSH_BEGIN) || !lines.get(lines.size() - 1).equals(SSH_END)) {
            throw new RuntimeException("Invalid OPENSSH file");
        }
        lines.remove(0);
        lines.remove(lines.size() - 1);
        StringBuilder base64StringBuilder = new StringBuilder();
        for (String line : lines) {
            base64StringBuilder.append(line);
        }
        String base64String = base64StringBuilder.toString();
        byte[] rawKey = AuthUtil.decodeString(base64String);
        byte[] verify = Arrays.copyOfRange(rawKey, 0, OPENSSH_KEY_V1.length());
        if (!new String(verify).equals(OPENSSH_KEY_V1)) {
            throw new RuntimeException("Invalid OPENSSH file");
        }
        boolean occurred = false;
        int index = 0;
        for (int i = 0; i < rawKey.length; ++i) {
            if (rawKey[i] != 115 || rawKey[i + 1] != 115 || rawKey[i + 2] != 104 || rawKey[i + 3] != 45 || rawKey[i + 4] != 101 || rawKey[i + 5] != 100 || rawKey[i + 6] != 50 || rawKey[i + 7] != 53 || rawKey[i + 8] != 53 || rawKey[i + 9] != 49 || rawKey[i + 10] != 57 || rawKey[i + 11] != 0 || rawKey[i + 12] != 0 || rawKey[i + 13] != 0 || rawKey[i + 14] != 32) continue;
            index = i + 15;
            if (occurred) break;
            occurred = true;
        }
        byte[] publicKey = Arrays.copyOfRange(rawKey, index, index + 32);
        for (int i = index += 32; i < rawKey.length; ++i) {
            if (rawKey[i] != 0 || rawKey[i + 1] != 0 || rawKey[i + 2] != 0 || rawKey[i + 3] != 64) continue;
            index = i + 4;
            break;
        }
        byte[] privateKey = Arrays.copyOfRange(rawKey, index, index + 32);
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        result.put("pubkey", publicKey);
        result.put("privkey", privateKey);
        return result;
    }
}

