/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.websocket;

import io.crossbar.autobahn.websocket.FrameProtocol;
import io.crossbar.autobahn.websocket.Handshake;
import io.crossbar.autobahn.websocket.exceptions.ParseFailed;
import io.crossbar.autobahn.websocket.messages.BinaryMessage;
import io.crossbar.autobahn.websocket.messages.ClientHandshake;
import io.crossbar.autobahn.websocket.messages.Close;
import io.crossbar.autobahn.websocket.messages.Message;
import io.crossbar.autobahn.websocket.messages.Ping;
import io.crossbar.autobahn.websocket.messages.Pong;
import io.crossbar.autobahn.websocket.messages.RawTextMessage;
import io.crossbar.autobahn.websocket.messages.TextMessage;
import io.crossbar.autobahn.websocket.types.WebSocketOptions;
import java.io.UnsupportedEncodingException;

public class Connection {
    private FrameProtocol mProtocol;
    private WebSocketOptions mOptions;

    public Connection(WebSocketOptions options) {
        this.mOptions = options;
        this.mProtocol = new FrameProtocol();
    }

    private byte[] sendText(String payload) throws ParseFailed {
        byte[] payloadBytes;
        try {
            payloadBytes = payload.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ParseFailed("payload is an invalid utf-8 string");
        }
        return this.sendText(payloadBytes);
    }

    private byte[] sendText(byte[] payload) throws ParseFailed {
        if (payload.length > this.mOptions.getMaxMessagePayloadSize()) {
            throw new ParseFailed("message payload exceeds payload limit");
        }
        return this.mProtocol.sendText(payload);
    }

    public byte[] send(Message msg) throws ParseFailed {
        if (msg instanceof TextMessage) {
            return this.sendText(((TextMessage)msg).mPayload);
        }
        if (msg instanceof RawTextMessage) {
            return this.sendText(((RawTextMessage)msg).mPayload);
        }
        if (msg instanceof BinaryMessage) {
            if (((BinaryMessage)msg).mPayload.length > this.mOptions.getMaxMessagePayloadSize()) {
                throw new ParseFailed("message payload exceeds payload limit");
            }
            return this.mProtocol.sendBinary(((BinaryMessage)msg).mPayload);
        }
        if (msg instanceof Ping) {
            return this.mProtocol.ping(((Ping)msg).mPayload);
        }
        if (msg instanceof Pong) {
            return this.mProtocol.pong(((Pong)msg).mPayload);
        }
        if (msg instanceof Close) {
            return this.mProtocol.close(((Close)msg).mCode, ((Close)msg).mReason);
        }
        if (msg instanceof ClientHandshake) {
            return Handshake.handshake((ClientHandshake)msg);
        }
        throw new ParseFailed("unknown message received by WebSocketWriter");
    }
}

