/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.websocket;

import io.crossbar.autobahn.websocket.exceptions.ParseFailed;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Random;

public class FrameProtocol {
    private static final int MAX_PAYLOAD_NORMAL = 125;
    private static final int MAX_PAYLOAD_TWO_BYTE = 65535;
    private final Random mRng = new Random();

    public byte[] ping(byte[] payload) throws ParseFailed {
        if (payload != null && payload.length > 125) {
            throw new ParseFailed("ping payload exceeds 125 octets");
        }
        return this.serializeFrame(9, payload, true, true);
    }

    public byte[] pong(byte[] payload) throws ParseFailed {
        if (payload != null && payload.length > 125) {
            throw new ParseFailed("ping payload exceeds 125 octets");
        }
        return this.serializeFrame(10, payload, true, true);
    }

    public byte[] close(int code, String reason) throws ParseFailed {
        if (code > 0) {
            byte[] payload;
            if (reason != null && !reason.equals("")) {
                try {
                    byte[] pReason = reason.getBytes("UTF-8");
                    payload = new byte[2 + pReason.length];
                    System.arraycopy(pReason, 0, payload, 2, pReason.length);
                }
                catch (UnsupportedEncodingException e) {
                    throw new ParseFailed("reason is an invalid utf-8 string");
                }
            } else {
                payload = new byte[]{(byte)(code >> 8 & 0xFF), (byte)(code & 0xFF)};
            }
            return this.serializeFrame(8, payload, true, true);
        }
        return this.serializeFrame(8, null, true, true);
    }

    public byte[] sendBinary(byte[] payload) {
        return this.serializeFrame(2, payload, true, true);
    }

    public byte[] sendText(byte[] payload) {
        return this.serializeFrame(1, payload, true, true);
    }

    private byte[] serializeFrame(int opcode, byte[] payload, boolean fin, boolean maskFrames) {
        byte[] payloadLength;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int b0 = 0;
        if (fin) {
            b0 = (byte)(b0 | 0xFFFFFF80);
        }
        b0 = (byte)(b0 | (byte)opcode);
        buffer.write(b0);
        int b1 = 0;
        if (maskFrames) {
            b1 = -128;
        }
        long len = 0L;
        if (payload != null) {
            len = payload.length;
        }
        if (len <= 125L) {
            b1 = (byte)(b1 | (byte)len);
            buffer.write(b1);
        } else if (len <= 65535L) {
            b1 = (byte)(b1 | 0x7E);
            buffer.write(b1);
            payloadLength = new byte[]{(byte)(len >> 8 & 0xFFL), (byte)(len & 0xFFL)};
            buffer.write(payloadLength, 0, payloadLength.length);
        } else {
            b1 = (byte)(b1 | 0x7F);
            buffer.write(b1);
            payloadLength = new byte[]{(byte)(len >> 56 & 0xFFL), (byte)(len >> 48 & 0xFFL), (byte)(len >> 40 & 0xFFL), (byte)(len >> 32 & 0xFFL), (byte)(len >> 24 & 0xFFL), (byte)(len >> 16 & 0xFFL), (byte)(len >> 8 & 0xFFL), (byte)(len & 0xFFL)};
            buffer.write(payloadLength, 0, payloadLength.length);
        }
        byte[] mask = null;
        if (maskFrames) {
            mask = this.newFrameMask();
            buffer.write(mask[0]);
            buffer.write(mask[1]);
            buffer.write(mask[2]);
            buffer.write(mask[3]);
        }
        if (len > 0L) {
            if (maskFrames) {
                int i = 0;
                while ((long)i < len) {
                    int n = i;
                    payload[n] = (byte)(payload[n] ^ mask[i % 4]);
                    ++i;
                }
            }
            buffer.write(payload, 0, payload.length);
        }
        return buffer.toByteArray();
    }

    private byte[] newFrameMask() {
        byte[] ba = new byte[4];
        this.mRng.nextBytes(ba);
        return ba;
    }
}

