/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.websocket;

import android.util.Base64;
import io.crossbar.autobahn.websocket.exceptions.ParseFailed;
import io.crossbar.autobahn.websocket.messages.ClientHandshake;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;

public class Handshake {
    private static final String CRLF = "\r\n";

    private static byte[] bytes(String text) throws IOException {
        return text.getBytes("UTF-8");
    }

    private static String newHandshakeKey() {
        byte[] ba = new byte[16];
        new Random().nextBytes(ba);
        return Base64.encodeToString((byte[])ba, (int)2);
    }

    public static byte[] handshake(ClientHandshake message) throws ParseFailed {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        String path = message.mQuery != null ? message.mPath + "?" + message.mQuery : message.mPath;
        try {
            buffer.write(Handshake.bytes(String.format("GET %s HTTP/1.1", path)));
            buffer.write(Handshake.bytes(CRLF));
            buffer.write(Handshake.bytes("Host: " + message.mHost));
            buffer.write(Handshake.bytes(CRLF));
            buffer.write(Handshake.bytes("Upgrade: WebSocket"));
            buffer.write(Handshake.bytes(CRLF));
            buffer.write(Handshake.bytes("Connection: Upgrade"));
            buffer.write(Handshake.bytes(CRLF));
            buffer.write(Handshake.bytes("Sec-WebSocket-Key: " + Handshake.newHandshakeKey()));
            buffer.write(Handshake.bytes(CRLF));
            if (message.mOrigin != null && !message.mOrigin.equals("")) {
                buffer.write(Handshake.bytes("Origin: " + message.mOrigin));
                buffer.write(Handshake.bytes(CRLF));
            }
            if (message.mSubprotocols != null && message.mSubprotocols.length > 0) {
                buffer.write(Handshake.bytes("Sec-WebSocket-Protocol: "));
                for (int i = 0; i < message.mSubprotocols.length; ++i) {
                    buffer.write(Handshake.bytes(message.mSubprotocols[i]));
                    if (i == message.mSubprotocols.length - 1) continue;
                    buffer.write(Handshake.bytes(", "));
                }
                buffer.write(Handshake.bytes(CRLF));
            }
            buffer.write(Handshake.bytes("Sec-WebSocket-Version: 13"));
            buffer.write(Handshake.bytes(CRLF));
            if (message.mHeaderList != null) {
                for (String key : message.mHeaderList.keySet()) {
                    buffer.write(Handshake.bytes(key + ":" + message.mHeaderList.get(key)));
                    buffer.write(Handshake.bytes(CRLF));
                }
            }
            buffer.write(Handshake.bytes(CRLF));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ParseFailed(e.getMessage());
        }
        return buffer.toByteArray();
    }
}

