/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.websocket;

import android.os.Handler;
import android.os.Looper;
import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import io.crossbar.autobahn.websocket.Connection;
import io.crossbar.autobahn.websocket.WebSocketReader;
import io.crossbar.autobahn.websocket.exceptions.ParseFailed;
import io.crossbar.autobahn.websocket.exceptions.WebSocketException;
import io.crossbar.autobahn.websocket.interfaces.IWebSocket;
import io.crossbar.autobahn.websocket.interfaces.IWebSocketConnectionHandler;
import io.crossbar.autobahn.websocket.messages.BinaryMessage;
import io.crossbar.autobahn.websocket.messages.CannotConnect;
import io.crossbar.autobahn.websocket.messages.ClientHandshake;
import io.crossbar.autobahn.websocket.messages.Close;
import io.crossbar.autobahn.websocket.messages.ConnectionLost;
import io.crossbar.autobahn.websocket.messages.Error;
import io.crossbar.autobahn.websocket.messages.Message;
import io.crossbar.autobahn.websocket.messages.Ping;
import io.crossbar.autobahn.websocket.messages.Pong;
import io.crossbar.autobahn.websocket.messages.ProtocolViolation;
import io.crossbar.autobahn.websocket.messages.RawTextMessage;
import io.crossbar.autobahn.websocket.messages.ServerError;
import io.crossbar.autobahn.websocket.messages.ServerHandshake;
import io.crossbar.autobahn.websocket.messages.TextMessage;
import io.crossbar.autobahn.websocket.types.ConnectionResponse;
import io.crossbar.autobahn.websocket.types.WebSocketOptions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class WebSocketConnection
implements IWebSocket {
    private static final IABLogger LOGGER = ABLogger.getLogger(WebSocketConnection.class.getName());
    private Handler mMasterHandler;
    private WebSocketReader mReader;
    private ExecutorService mWriterThread;
    private Connection mWebSocket;
    private BufferedOutputStream mBufferedOutputStream;
    private Socket mSocket;
    private URI mWsUri;
    private String mWsScheme;
    private String mWsHost;
    private int mWsPort;
    private String mWsPath;
    private String mWsQuery;
    private String[] mWsSubprotocols;
    private Map<String, String> mWsHeaders;
    private IWebSocketConnectionHandler mWsHandler;
    private WebSocketOptions mOptions;
    private boolean mActive;
    private boolean mPrevConnected;
    private boolean onCloseCalled;
    private ScheduledExecutorService mExecutor;
    private ScheduledFuture<?> mPingerTask;
    private final Runnable mAutoPinger = new Runnable(){

        @Override
        public void run() {
            if (WebSocketConnection.this.mReader != null && WebSocketConnection.this.mReader.getTimeSinceLastRead() >= (double)(WebSocketConnection.this.mOptions.getAutoPingInterval() - 1)) {
                WebSocketConnection.this.sendPing();
                WebSocketConnection.this.mExecutor.schedule(() -> {
                    if (WebSocketConnection.this.mReader.getTimeSinceLastRead() < (double)WebSocketConnection.this.mOptions.getAutoPingInterval()) {
                        return;
                    }
                    WebSocketConnection.this.forward(new ConnectionLost("AutoPing timed out."));
                }, (long)WebSocketConnection.this.mOptions.getAutoPingTimeout(), TimeUnit.SECONDS);
            }
        }
    };

    private void forward(Object message) {
        android.os.Message msg = this.mMasterHandler.obtainMessage();
        msg.obj = message;
        this.mMasterHandler.sendMessage(msg);
    }

    public WebSocketConnection() {
        LOGGER.d("Created");
        this.createHandler();
        this.mActive = false;
        this.mPrevConnected = false;
    }

    @Override
    public void sendMessage(String payload) {
        this.sendMessage(new TextMessage(payload));
    }

    @Override
    public void sendMessage(byte[] payload, boolean isBinary) {
        if (isBinary) {
            this.sendMessage(new BinaryMessage(payload));
        } else {
            this.sendMessage(new RawTextMessage(payload));
        }
    }

    @Override
    public void sendPing() {
        this.sendMessage(new Ping());
    }

    @Override
    public void sendPing(byte[] payload) {
        this.sendMessage(new Ping(payload));
    }

    @Override
    public void sendPong() {
        this.sendMessage(new Pong());
    }

    @Override
    public void sendPong(byte[] payload) {
        this.sendMessage(new Pong(payload));
    }

    @Override
    public boolean isConnected() {
        return this.mSocket != null && this.mSocket.isConnected() && !this.mSocket.isClosed();
    }

    private void closeReaderThread(boolean waitForQuit) {
        if (this.mReader != null) {
            this.mReader.quit();
            if (waitForQuit) {
                try {
                    this.mReader.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            LOGGER.d("mReader already NULL");
        }
    }

    private void closeUnderlyingSocket() throws IOException, InterruptedException {
        Thread cleaner = new Thread(() -> {
            if (this.isConnected()) {
                try {
                    this.mSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        cleaner.start();
        cleaner.join();
    }

    private void closeWriterThread() {
        try {
            this.mWriterThread.shutdown();
            this.mWriterThread.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.v(e.getMessage(), e);
        }
    }

    private void failConnection(int code, String reason) {
        LOGGER.d("fail connection [code = " + code + ", reason = " + reason);
        this.closeReaderThread(false);
        this.closeWriterThread();
        if (this.isConnected()) {
            try {
                this.closeUnderlyingSocket();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.v(e.getMessage(), e);
            }
        } else {
            LOGGER.d("Socket already closed");
        }
        this.closeReaderThread(true);
        this.onClose(code, reason);
        LOGGER.d("Worker threads stopped");
    }

    @Override
    public void connect(String wsUri, IWebSocketConnectionHandler wsHandler) throws WebSocketException {
        this.connect(wsUri, null, wsHandler, null, null);
    }

    @Override
    public void connect(String wsUri, IWebSocketConnectionHandler wsHandler, WebSocketOptions options) throws WebSocketException {
        this.connect(wsUri, null, wsHandler, options, null);
    }

    @Override
    public void connect(String wsUri, String[] wsSubprotocols, IWebSocketConnectionHandler wsHandler) throws WebSocketException {
        this.connect(wsUri, wsSubprotocols, wsHandler, new WebSocketOptions(), null);
    }

    @Override
    public void connect(String wsUri, String[] wsSubprotocols, IWebSocketConnectionHandler wsHandler, WebSocketOptions options, Map<String, String> headers) throws WebSocketException {
        if (this.isConnected()) {
            throw new WebSocketException("already connected");
        }
        try {
            this.mWsUri = new URI(wsUri);
            this.mWsScheme = this.mWsUri.getScheme();
            if (this.mWsScheme == null || !this.mWsScheme.equals("ws") && !this.mWsScheme.equals("wss")) {
                throw new WebSocketException("unsupported scheme for WebSockets URI");
            }
            this.mWsPort = this.mWsUri.getPort() == -1 ? (this.mWsScheme.equals("ws") ? 80 : 443) : this.mWsUri.getPort();
            if (this.mWsUri.getHost() == null) {
                throw new WebSocketException("no host specified in WebSockets URI");
            }
            this.mWsHost = this.mWsUri.getHost();
            this.mWsPath = this.mWsUri.getRawPath() == null || this.mWsUri.getRawPath().equals("") ? "/" : this.mWsUri.getRawPath();
            this.mWsQuery = this.mWsUri.getRawQuery() == null || this.mWsUri.getRawQuery().equals("") ? null : this.mWsUri.getRawQuery();
        }
        catch (URISyntaxException e) {
            throw new WebSocketException("invalid WebSockets URI");
        }
        this.mWsSubprotocols = wsSubprotocols;
        this.mWsHeaders = headers;
        this.mWsHandler = wsHandler;
        if (this.mOptions == null) {
            this.mOptions = options == null ? new WebSocketOptions() : new WebSocketOptions(options);
        } else if (options != null) {
            this.mOptions = new WebSocketOptions(options);
        }
        this.mActive = true;
        this.onCloseCalled = false;
        new WebSocketConnector().start();
    }

    @Override
    public void sendClose() {
        this.sendClose(1000);
    }

    @Override
    public void sendClose(int code) {
        this.sendClose(code, null);
    }

    @Override
    public void sendClose(int code, String reason) {
        this.sendMessage(new Close(code, reason));
        this.onCloseCalled = false;
        this.mActive = false;
        this.mPrevConnected = false;
    }

    public boolean reconnect() {
        if (!this.isConnected() && this.mWsUri != null) {
            this.onCloseCalled = false;
            new WebSocketConnector().start();
            return true;
        }
        return false;
    }

    private boolean scheduleReconnect() {
        boolean need;
        int interval = this.mOptions.getReconnectInterval();
        boolean bl = need = this.mActive && this.mPrevConnected && interval > 0;
        if (need) {
            LOGGER.d("Reconnection scheduled");
            this.mMasterHandler.postDelayed(() -> {
                LOGGER.d("Reconnecting...");
                this.reconnect();
            }, (long)interval);
        }
        return need;
    }

    private void onClose(int code, String reason) {
        block7: {
            boolean reconnecting = false;
            if (code == 2 || code == 3) {
                reconnecting = this.scheduleReconnect();
            }
            if (this.mExecutor != null) {
                this.mExecutor.shutdown();
            }
            if (this.mWsHandler != null) {
                try {
                    if (reconnecting) {
                        this.mWsHandler.onClose(7, reason);
                        break block7;
                    }
                    this.mWsHandler.onClose(code, reason);
                }
                catch (Exception e) {
                    LOGGER.v(e.getMessage(), e);
                }
            } else {
                LOGGER.d("mWsHandler already NULL");
            }
        }
        this.onCloseCalled = true;
    }

    private void closeAndCleanup() {
        this.closeReaderThread(false);
        this.closeWriterThread();
        if (this.isConnected()) {
            try {
                this.closeUnderlyingSocket();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.v(e.getMessage(), e);
            }
        }
        this.closeReaderThread(true);
        this.onCloseCalled = false;
    }

    private <T> T getOrDefault(Map<?, ?> obj, Object key, T default_value) {
        if (obj.containsKey(key)) {
            return (T)obj.get(key);
        }
        return default_value;
    }

    public void setOptions(WebSocketOptions options) {
        if (this.mOptions == null) {
            this.mOptions = new WebSocketOptions(options);
        } else {
            this.mOptions.setAutoPingInterval(options.getAutoPingInterval());
            this.mOptions.setAutoPingTimeout(options.getAutoPingTimeout());
            if (this.mPingerTask != null) {
                this.mPingerTask.cancel(true);
            }
            if (this.mExecutor == null) {
                this.mExecutor = Executors.newSingleThreadScheduledExecutor();
            }
            if (this.mOptions.getAutoPingInterval() > 0) {
                this.mPingerTask = this.mExecutor.scheduleAtFixedRate(this.mAutoPinger, 0L, this.mOptions.getAutoPingInterval(), TimeUnit.SECONDS);
            }
        }
    }

    private void createHandler() {
        this.mMasterHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(android.os.Message msg) {
                if (WebSocketConnection.this.onCloseCalled) {
                    LOGGER.d("onClose called already, ignore message.");
                    return;
                }
                if (msg.obj instanceof TextMessage) {
                    TextMessage textMessage = (TextMessage)msg.obj;
                    if (WebSocketConnection.this.mWsHandler != null) {
                        WebSocketConnection.this.mWsHandler.onMessage(textMessage.mPayload);
                    } else {
                        LOGGER.d("could not call onTextMessage() .. handler already NULL");
                    }
                } else if (msg.obj instanceof RawTextMessage) {
                    RawTextMessage rawTextMessage = (RawTextMessage)msg.obj;
                    if (WebSocketConnection.this.mWsHandler != null) {
                        WebSocketConnection.this.mWsHandler.onMessage(rawTextMessage.mPayload, false);
                    } else {
                        LOGGER.d("could not call onRawTextMessage() .. handler already NULL");
                    }
                } else if (msg.obj instanceof BinaryMessage) {
                    BinaryMessage binaryMessage = (BinaryMessage)msg.obj;
                    if (WebSocketConnection.this.mWsHandler != null) {
                        WebSocketConnection.this.mWsHandler.onMessage(binaryMessage.mPayload, true);
                    } else {
                        LOGGER.d("could not call onBinaryMessage() .. handler already NULL");
                    }
                } else if (msg.obj instanceof Ping) {
                    Ping ping = (Ping)msg.obj;
                    LOGGER.d("WebSockets Ping received");
                    if (ping.mPayload == null) {
                        WebSocketConnection.this.mWsHandler.onPing();
                    } else {
                        WebSocketConnection.this.mWsHandler.onPing(ping.mPayload);
                    }
                    LOGGER.d("WebSockets Pong sent");
                } else if (msg.obj instanceof Pong) {
                    Pong pong = (Pong)msg.obj;
                    if (pong.mPayload == null) {
                        WebSocketConnection.this.mWsHandler.onPong();
                    } else {
                        WebSocketConnection.this.mWsHandler.onPong(pong.mPayload);
                    }
                    LOGGER.d("WebSockets Pong received");
                } else if (msg.obj instanceof Close) {
                    int crossbarCloseCode;
                    Close close = (Close)msg.obj;
                    int n = crossbarCloseCode = close.mCode == 1000 ? 1 : 3;
                    if (close.mIsReply) {
                        LOGGER.d("WebSockets Close received (" + close.mCode + " - " + close.mReason + ")");
                        WebSocketConnection.this.closeAndCleanup();
                        WebSocketConnection.this.onClose(crossbarCloseCode, close.mReason);
                    } else if (WebSocketConnection.this.mActive) {
                        WebSocketConnection.this.closeReaderThread(false);
                        WebSocketConnection.this.sendMessage(new Close(1000, true));
                        WebSocketConnection.this.mActive = false;
                    } else {
                        LOGGER.d("WebSockets Close received (" + close.mCode + " - " + close.mReason + ")");
                        WebSocketConnection.this.closeAndCleanup();
                        WebSocketConnection.this.onClose(crossbarCloseCode, close.mReason);
                    }
                } else if (msg.obj instanceof ServerHandshake) {
                    ServerHandshake serverHandshake = (ServerHandshake)msg.obj;
                    LOGGER.d("opening handshake received");
                    if (serverHandshake.mSuccess) {
                        if (WebSocketConnection.this.mWsHandler != null) {
                            if (WebSocketConnection.this.mOptions.getAutoPingInterval() > 0) {
                                WebSocketConnection.this.mPingerTask = WebSocketConnection.this.mExecutor.scheduleAtFixedRate(WebSocketConnection.this.mAutoPinger, 0L, WebSocketConnection.this.mOptions.getAutoPingInterval(), TimeUnit.SECONDS);
                            }
                            String protocol = (String)WebSocketConnection.this.getOrDefault(serverHandshake.headers, "Sec-WebSocket-Protocol", null);
                            WebSocketConnection.this.mWsHandler.setConnection(WebSocketConnection.this);
                            WebSocketConnection.this.mWsHandler.onConnect(new ConnectionResponse(protocol));
                            WebSocketConnection.this.mWsHandler.onOpen();
                            LOGGER.d("onOpen() called, ready to rock.");
                        } else {
                            LOGGER.d("could not call onOpen() .. handler already NULL");
                        }
                    }
                } else if (msg.obj instanceof CannotConnect) {
                    CannotConnect cannotConnect = (CannotConnect)msg.obj;
                    WebSocketConnection.this.failConnection(2, cannotConnect.reason);
                } else if (msg.obj instanceof ConnectionLost) {
                    ConnectionLost connnectionLost = (ConnectionLost)msg.obj;
                    WebSocketConnection.this.failConnection(3, connnectionLost.reason);
                } else if (msg.obj instanceof ProtocolViolation) {
                    ProtocolViolation protocolViolation = (ProtocolViolation)msg.obj;
                    WebSocketConnection.this.failConnection(4, "WebSockets protocol violation");
                } else if (msg.obj instanceof Error) {
                    Error error = (Error)msg.obj;
                    WebSocketConnection.this.failConnection(5, "WebSockets internal error (" + error.mException.toString() + ")");
                } else if (msg.obj instanceof ServerError) {
                    ServerError error = (ServerError)msg.obj;
                    WebSocketConnection.this.failConnection(6, "Server error " + error.mStatusCode + " (" + error.mStatusMessage + ")");
                } else {
                    WebSocketConnection.this.processAppMessage(msg.obj);
                }
            }
        };
    }

    private void processAppMessage(Object message) {
    }

    private void createWriter() throws IOException {
        this.mWriterThread = Executors.newSingleThreadExecutor();
        this.mBufferedOutputStream = new BufferedOutputStream(this.mSocket.getOutputStream(), this.mOptions.getMaxFramePayloadSize() + 14);
        this.mWebSocket = new Connection(this.mOptions);
        LOGGER.d("WS writer created and started");
    }

    private void sendMessage(final Message message) {
        if (this.mWriterThread == null || this.mWriterThread.isShutdown()) {
            return;
        }
        this.mWriterThread.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    WebSocketConnection.this.mBufferedOutputStream.write(WebSocketConnection.this.mWebSocket.send(message));
                    WebSocketConnection.this.mBufferedOutputStream.flush();
                    if (message instanceof Close) {
                        Close msg = (Close)message;
                        if (msg.mIsReply) {
                            WebSocketConnection.this.forward(message);
                        }
                    }
                }
                catch (SocketException e) {
                    LOGGER.d("run() : SocketException (" + e.toString() + ")");
                    WebSocketConnection.this.forward(new ConnectionLost(null));
                }
                catch (ParseFailed | IOException e) {
                    LOGGER.w(e.getMessage(), e);
                    WebSocketConnection.this.forward(new Error(e));
                }
            }
        });
    }

    private void createReader() throws IOException {
        this.mReader = new WebSocketReader(this.mMasterHandler, this.mSocket, this.mOptions, "WebSocketReader");
        this.mReader.start();
        LOGGER.d("WS reader created and started");
    }

    private void setEnabledProtocolsOnSSLSocket(Socket socket, String[] protocols) {
        if (socket != null && socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(protocols);
        }
    }

    private class WebSocketConnector
    extends Thread {
        private WebSocketConnector() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("WebSocketConnector");
            try {
                if (WebSocketConnection.this.mWsScheme.equals("wss")) {
                    WebSocketConnection.this.mSocket = SSLSocketFactory.getDefault().createSocket();
                } else {
                    WebSocketConnection.this.mSocket = SocketFactory.getDefault().createSocket();
                }
                if (WebSocketConnection.this.mOptions.getTLSEnabledProtocols() != null) {
                    WebSocketConnection.this.setEnabledProtocolsOnSSLSocket(WebSocketConnection.this.mSocket, WebSocketConnection.this.mOptions.getTLSEnabledProtocols());
                }
                WebSocketConnection.this.mSocket.connect(new InetSocketAddress(WebSocketConnection.this.mWsHost, WebSocketConnection.this.mWsPort), WebSocketConnection.this.mOptions.getSocketConnectTimeout());
                WebSocketConnection.this.mSocket.setSoTimeout(WebSocketConnection.this.mOptions.getSocketReceiveTimeout());
                WebSocketConnection.this.mSocket.setTcpNoDelay(WebSocketConnection.this.mOptions.getTcpNoDelay());
            }
            catch (IOException e) {
                WebSocketConnection.this.forward(new CannotConnect(e.getMessage()));
                return;
            }
            if (WebSocketConnection.this.mExecutor == null || WebSocketConnection.this.mExecutor.isShutdown()) {
                WebSocketConnection.this.mExecutor = Executors.newSingleThreadScheduledExecutor();
            }
            if (WebSocketConnection.this.isConnected()) {
                try {
                    WebSocketConnection.this.createReader();
                    WebSocketConnection.this.createWriter();
                    ClientHandshake hs = new ClientHandshake(WebSocketConnection.this.mWsHost + ":" + WebSocketConnection.this.mWsPort);
                    hs.mPath = WebSocketConnection.this.mWsPath;
                    hs.mQuery = WebSocketConnection.this.mWsQuery;
                    hs.mSubprotocols = WebSocketConnection.this.mWsSubprotocols;
                    hs.mHeaderList = WebSocketConnection.this.mWsHeaders;
                    WebSocketConnection.this.sendMessage(hs);
                    WebSocketConnection.this.mPrevConnected = true;
                }
                catch (Exception e) {
                    WebSocketConnection.this.forward(new Error(e));
                }
            } else {
                WebSocketConnection.this.forward(new CannotConnect("Could not connect to WebSocket server"));
            }
        }
    }
}

