/*
 * Decompiled with CFR 0.152.
 */
package xbr.network;

import com.fasterxml.jackson.core.type.TypeReference;
import io.crossbar.autobahn.wamp.Session;
import java.security.SecureRandom;
import java.util.HashMap;
import java8.util.concurrent.CompletableFuture;
import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.utils.Numeric;

public class SimpleBuyer {
    private final String mEthPrivateKey;
    private final String mEthPublicKey;
    private final int mMaxPrice;
    private final byte[] mPrivateKey;
    private final byte[] mPublicKey;
    private final ECKeyPair mECKey;
    private HashMap<String, String> mKeys;
    private Session mSession;
    private boolean mRunning;
    private long mRemainingBalance;
    private HashMap<String, Object> mChannel;

    public SimpleBuyer(String buyerKey, int maxPrice) {
        this.mECKey = ECKeyPair.create((byte[])Numeric.hexStringToByteArray((String)buyerKey));
        this.mEthPrivateKey = Numeric.toHexString((byte[])this.mECKey.getPrivateKey().toByteArray());
        this.mEthPublicKey = Numeric.toHexString((byte[])this.mECKey.getPublicKey().toByteArray());
        this.mMaxPrice = maxPrice;
        this.mKeys = new HashMap();
        this.mPrivateKey = new byte[32];
        this.mPublicKey = new byte[32];
        NaCl.sodium();
        Sodium.crypto_box_keypair((byte[])this.mPublicKey, (byte[])this.mPrivateKey);
    }

    public CompletableFuture<Long> start(Session session, long consumerID) {
        CompletableFuture future = new CompletableFuture();
        if (this.mRunning) {
            throw new IllegalStateException("Already running...");
        }
        this.mSession = session;
        this.mRunning = true;
        CompletableFuture<HashMap<String, Object>> callFuture = session.call("xbr.marketmaker.get_payment_channel", new TypeReference<HashMap<String, Object>>(){}, new Object[]{Keys.getAddress((byte[])this.mPublicKey)});
        callFuture.whenComplete((result, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
            } else {
                this.mChannel = result;
                this.mRemainingBalance = ((Integer)result.get("remaining")).intValue();
                future.complete((Object)this.mRemainingBalance);
            }
        });
        return future;
    }

    public void stop() {
        if (!this.mRunning) {
            throw new IllegalStateException("Already stopped...");
        }
        this.mRunning = false;
    }

    public CompletableFuture<HashMap<String, Object>> balance() {
        CompletableFuture future = new CompletableFuture();
        if (this.mSession == null || !this.mSession.isConnected()) {
            throw new IllegalStateException("Session not connected");
        }
        CompletableFuture<HashMap<String, Object>> callFuture = this.mSession.call("xbr.marketmaker.get_payment_channel", new TypeReference<HashMap<String, Object>>(){}, new Object[]{Keys.getAddress((byte[])this.mPublicKey)});
        callFuture.whenComplete((result, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
            } else {
                HashMap res = new HashMap();
                res.put("amount", result.get("amount"));
                res.put("remaining", result.get("remaining"));
                res.put("inflight", result.get("inflight"));
                future.complete(res);
            }
        });
        return future;
    }

    public CompletableFuture<HashMap<String, Object>> openChannel(byte[] buyerAddr, long amount) {
        CompletableFuture future = new CompletableFuture();
        if (this.mSession == null || !this.mSession.isConnected()) {
            throw new IllegalStateException("Session not connected");
        }
        CompletableFuture<HashMap<String, Object>> callFuture = this.mSession.call("xbr.marketmaker.open_payment_channel", new TypeReference<HashMap<String, Object>>(){}, new Object[]{buyerAddr, Keys.getAddress((byte[])this.mPublicKey), amount, new SecureRandom(new byte[64])});
        callFuture.whenComplete((result, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
            } else {
                HashMap res = new HashMap();
                res.put("amount", result.get("amount"));
                res.put("remaining", result.get("remaining"));
                res.put("inflight", result.get("inflight"));
                future.complete(res);
            }
        });
        return future;
    }

    public void closeChannel() {
    }

    public CompletableFuture<String> unwrap(byte[] keyID, String encSerializer, String ciphertext) {
        CompletableFuture future = new CompletableFuture();
        if (!this.mKeys.containsKey(keyID)) {
            int amount = this.mMaxPrice;
            byte[] signature = Hash.sha256((byte[])new byte[64]);
            byte[] key = new byte[16];
            NaCl.sodium();
            Sodium.randombytes((byte[])key, (int)16);
            CompletableFuture<HashMap<String, Object>> callFuture = this.mSession.call("xbr.marketmaker.buy_key", new TypeReference<HashMap<String, Object>>(){}, new Object[]{Keys.getAddress((byte[])this.mPublicKey), this.mPublicKey, key, amount, signature});
            callFuture.whenComplete((stringObjectHashMap, throwable) -> {
                if (throwable != null) {
                    throwable.printStackTrace();
                } else {
                    System.out.println(stringObjectHashMap);
                }
            });
        }
        return future;
    }
}

