/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.exceptions.ProtocolError;
import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Error
implements IMessage {
    public static final int MESSAGE_TYPE = 8;
    public final int requestType;
    public final long request;
    public final String error;
    public final List<Object> args;
    public final Map<String, Object> kwargs;

    public Error(int requestType, long request, String error, List<Object> args, Map<String, Object> kwargs) {
        this.requestType = requestType;
        this.request = request;
        this.error = error;
        this.args = args;
        this.kwargs = kwargs;
    }

    public static Error parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 8, "ERROR", 5, 7);
        int requestType = (Integer)wmsg.get(1);
        long request = MessageUtil.parseLong(wmsg.get(2));
        Map details = (Map)wmsg.get(3);
        String error = (String)wmsg.get(4);
        if (wmsg.size() == 6 && wmsg.get(5) instanceof byte[]) {
            throw new ProtocolError("Binary payload not supported");
        }
        List args = null;
        if (wmsg.size() > 5) {
            args = (List)wmsg.get(5);
        }
        Map kwargs = null;
        if (wmsg.size() > 6) {
            kwargs = (Map)wmsg.get(6);
        }
        return new Error(requestType, request, error, args, kwargs);
    }

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(8);
        marshaled.add(this.requestType);
        marshaled.add(this.request);
        marshaled.add(new HashMap());
        marshaled.add(this.error);
        if (this.kwargs != null) {
            if (this.args == null) {
                marshaled.add(Collections.emptyList());
            } else {
                marshaled.add(this.args);
            }
            marshaled.add(this.kwargs);
        } else if (this.args != null) {
            marshaled.add(this.args);
        }
        return marshaled;
    }
}

