/*
 * Decompiled with CFR 0.152.
 */
package xbr.network;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.web3j.crypto.ECDSASignature;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;
import xbr.network.web3.StructuredDataEncoder;

public class Util {
    private static final String VERIFYING_ADDR = "0x254dffcd3277C0b1660F6d42EFbB754edaBAbC2B";

    public static BigInteger toXBR(int xbr) {
        return BigInteger.valueOf(xbr).multiply(BigInteger.valueOf(10L).pow(18));
    }

    public static BigInteger toXBR(byte[] xbr) {
        return new BigInteger(xbr);
    }

    public static BigInteger toXBR(Object xbr) {
        return new BigInteger((byte[])xbr);
    }

    private static JSONObject createEIP712Data(String verifyingAddr, byte[] channelAddr, int channelSeq, BigInteger balance, boolean isFinal) throws JSONException {
        JSONObject result = new JSONObject();
        JSONObject types = new JSONObject();
        JSONArray eip712Domain = new JSONArray("[{'name': 'name', 'type': 'string'}, {'name': 'version', 'type': 'string'}, {'name': 'chainId', 'type': 'uint256'}, {'name': 'verifyingContract', 'type': 'address'}]");
        JSONArray channelClose = new JSONArray("[{'name': 'channel_adr', 'type': 'address'}, {'name': 'channel_seq', 'type': 'uint32'}, {'name': 'balance', 'type': 'uint256'}, {'name': 'is_final', 'type': 'bool'},]");
        types.put("EIP712Domain", (Object)eip712Domain);
        types.put("ChannelClose", (Object)channelClose);
        result.put("types", (Object)types);
        result.put("primaryType", (Object)"ChannelClose");
        JSONObject domain = new JSONObject();
        domain.put("name", (Object)"XBR");
        domain.put("version", (Object)"1");
        domain.put("chainId", 1);
        domain.put("verifyingContract", (Object)verifyingAddr);
        result.put("domain", (Object)domain);
        JSONObject message = new JSONObject();
        message.put("channel_adr", (Object)Numeric.toHexString((byte[])channelAddr));
        message.put("channel_seq", channelSeq);
        message.put("balance", (Object)balance);
        message.put("is_final", isFinal);
        result.put("message", (Object)message);
        return result;
    }

    static byte[] signEIP712Data(ECKeyPair keyPair, byte[] channelAddr, int channelSeq, BigInteger balance, boolean isFinal) throws IOException, JSONException {
        JSONObject data = Util.createEIP712Data(VERIFYING_ADDR, channelAddr, channelSeq, balance, isFinal);
        StructuredDataEncoder encoder = new StructuredDataEncoder(data.toString());
        byte[] message = encoder.hashStructuredData();
        Sign.SignatureData signed = Sign.signMessage((byte[])message, (ECKeyPair)keyPair, (boolean)false);
        byte[] r = signed.getR();
        byte[] s = signed.getS();
        byte[] result = new byte[65];
        System.arraycopy(r, 0, result, 0, r.length);
        System.arraycopy(s, 0, result, r.length, s.length);
        result[64] = signed.getV();
        return result;
    }

    static String recoverEIP712Signer(byte[] channelAddr, int channelSeq, BigInteger balance, boolean isFinal, byte[] signature) {
        try {
            byte[] s;
            byte[] r;
            Sign.SignatureData sd;
            int recID;
            BigInteger publicKey;
            JSONObject data = Util.createEIP712Data(VERIFYING_ADDR, channelAddr, channelSeq, balance, isFinal);
            StructuredDataEncoder encoder = new StructuredDataEncoder(data.toString());
            byte[] message = encoder.hashStructuredData();
            byte v = signature[64];
            if (v < 27) {
                v = (byte)(v + 27);
            }
            if ((publicKey = Sign.recoverFromSignature((int)((byte)(recID = v - 27)), (ECDSASignature)new ECDSASignature(new BigInteger(1, (sd = new Sign.SignatureData(v, r = Arrays.copyOfRange(signature, 0, 32), s = Arrays.copyOfRange(signature, 32, 64))).getR()), new BigInteger(1, sd.getS())), (byte[])message)) != null) {
                return "0x" + Keys.getAddress((BigInteger)publicKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

