/*
 * Decompiled with CFR 0.152.
 */
package xbr.network.crypto;

import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;
import org.libsodium.jni.crypto.Util;
import org.libsodium.jni.encoders.Encoder;

public class SealedBox {
    private static final int MAC_BYTES = 16;
    private static final int SEAL_BYTES = 48;
    private byte[] publicKey;
    private byte[] privateKey;

    public SealedBox(byte[] publicKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key must not be null");
        }
        this.publicKey = publicKey;
        this.privateKey = null;
    }

    public SealedBox(String publicKey, Encoder encoder) {
        this(encoder.decode(publicKey));
    }

    public SealedBox(byte[] publicKey, byte[] privateKey) {
        if (publicKey == null) {
            throw new IllegalArgumentException("Public key must not be null");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("Private key must not be null");
        }
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public SealedBox(String publicKey, String privateKey, Encoder encoder) {
        this(encoder.decode(publicKey), encoder.decode(privateKey));
    }

    public byte[] encrypt(byte[] message) {
        byte[] ct = new byte[message.length + 48];
        NaCl.sodium();
        Util.isValid((int)Sodium.crypto_box_seal((byte[])ct, (byte[])message, (int)message.length, (byte[])this.publicKey), (String)"Encryption failed");
        return ct;
    }

    public byte[] decrypt(byte[] ciphertext) {
        byte[] message = new byte[ciphertext.length - 48];
        NaCl.sodium();
        Util.isValid((int)Sodium.crypto_box_seal_open((byte[])message, (byte[])ciphertext, (int)ciphertext.length, (byte[])this.publicKey, (byte[])this.privateKey), (String)"Decryption failed. Ciphertext failed verification");
        return message;
    }
}

