/*
 * Decompiled with CFR 0.152.
 */
package xbr.network.crypto;

import java.util.Arrays;
import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;
import org.libsodium.jni.crypto.Random;
import org.libsodium.jni.crypto.Util;
import org.libsodium.jni.encoders.Encoder;

public class SecretBox {
    private byte[] mKey;
    private Encoder mEncoder;

    public SecretBox(byte[] key) {
        Util.checkLength((byte[])key, (int)32);
        this.mEncoder = Encoder.RAW;
        this.mKey = key;
    }

    public byte[] encrypt(byte[] message) {
        byte[] nonce = new Random().randomBytes(24);
        return this.encrypt(nonce, message);
    }

    public byte[] encrypt(byte[] nonce, byte[] message) {
        Util.checkLength((byte[])nonce, (int)24);
        byte[] msg = Util.prependZeros((int)32, (byte[])message);
        byte[] ct = Util.zeros((int)msg.length);
        NaCl.sodium();
        Util.isValid((int)Sodium.crypto_secretbox_xsalsa20poly1305((byte[])ct, (byte[])msg, (int)msg.length, (byte[])nonce, (byte[])this.mKey), (String)"Encryption failed");
        byte[] cipherWithoutNonce = Util.removeZeros((int)16, (byte[])ct);
        byte[] ciphertext = new byte[cipherWithoutNonce.length + 24];
        System.arraycopy(nonce, 0, ciphertext, 0, nonce.length);
        System.arraycopy(cipherWithoutNonce, 0, ciphertext, nonce.length, cipherWithoutNonce.length);
        return ciphertext;
    }

    public byte[] decrypt(byte[] ciphertext) {
        byte[] nonce = Arrays.copyOfRange(ciphertext, 0, 24);
        byte[] message = Arrays.copyOfRange(ciphertext, 24, ciphertext.length);
        return this.decrypt(nonce, message);
    }

    public byte[] decrypt(byte[] nonce, byte[] ciphertext) {
        Util.checkLength((byte[])nonce, (int)24);
        byte[] ct = Util.prependZeros((int)16, (byte[])ciphertext);
        byte[] message = Util.zeros((int)ct.length);
        NaCl.sodium();
        Util.isValid((int)Sodium.crypto_secretbox_xsalsa20poly1305_open((byte[])message, (byte[])ct, (int)ct.length, (byte[])nonce, (byte[])this.mKey), (String)"Decryption failed. Ciphertext failed verification");
        return Util.removeZeros((int)32, (byte[])message);
    }
}

