/*
 * Decompiled with CFR 0.152.
 */
package io.crossplane.compositefunctions.base;

import io.crossplane.compositefunctions.base.CrossplaneFunctionRequest;
import io.crossplane.compositefunctions.base.CrossplaneFunctionResponse;
import io.crossplane.compositefunctions.base.CrossplaneObjectToProtobufConverter;
import io.crossplane.compositefunctions.protobuf.v1.FunctionRunnerServiceGrpc;
import io.crossplane.compositefunctions.protobuf.v1.Requirements;
import io.crossplane.compositefunctions.protobuf.v1.RunFunctionRequest;
import io.crossplane.compositefunctions.protobuf.v1.RunFunctionResponse;
import io.crossplane.compositefunctions.protobuf.v1.State;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CrossplaneCompositeFunctionBase
extends FunctionRunnerServiceGrpc.FunctionRunnerServiceImplBase {
    private static final Logger logger = LoggerFactory.getLogger(CrossplaneCompositeFunctionBase.class);

    public void runFunction(RunFunctionRequest request, StreamObserver<RunFunctionResponse> responseObserver) {
        try {
            State.Builder desiredBuilder = State.newBuilder();
            State desired = request.getDesired();
            desiredBuilder.putAllResources(desired.getResourcesMap());
            CrossplaneFunctionRequest crossplaneFunctionRequest = new CrossplaneFunctionRequest(request.getObserved(), request.getExtraResourcesMap(), request.getCredentialsMap(), request.getDesired());
            logger.debug("Calling method with implemented logic");
            CrossplaneFunctionResponse crossplaneFunctionResponse = this.runFunction(crossplaneFunctionRequest);
            logger.debug("Finished calling method with implemented logic");
            for (Map.Entry<String, Object> entry : crossplaneFunctionResponse.desiredResources().entrySet()) {
                desiredBuilder.putResources(entry.getKey(), CrossplaneObjectToProtobufConverter.convertToResource(entry.getValue()));
            }
            RunFunctionResponse.Builder responseBuilder = RunFunctionResponse.newBuilder();
            if (!crossplaneFunctionResponse.resourceSelectors().isEmpty()) {
                Requirements requirements = Requirements.newBuilder().putAllExtraResources(crossplaneFunctionResponse.resourceSelectors()).build();
                responseBuilder.setRequirements(requirements);
            }
            if (!crossplaneFunctionResponse.results().isEmpty()) {
                responseBuilder.addAllResults(crossplaneFunctionResponse.results());
            }
            if (!crossplaneFunctionResponse.conditions().isEmpty()) {
                responseBuilder.addAllConditions(crossplaneFunctionResponse.conditions());
            }
            if (desiredBuilder.getResourcesCount() > 0) {
                responseBuilder.setDesired(desiredBuilder.build());
            }
            RunFunctionResponse runFunctionResponse = responseBuilder.build();
            responseObserver.onNext((Object)runFunctionResponse);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            logger.error("Error when running function logic", (Throwable)e);
            responseObserver.onError((Throwable)e);
        }
    }

    public abstract CrossplaneFunctionResponse runFunction(CrossplaneFunctionRequest var1);
}

