/*
 * Decompiled with CFR 0.152.
 */
package io.crossplane.compositefunctions.starter.conversion;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.crossplane.compositefunctions.protobuf.v1.Resource;
import io.crossplane.compositefunctions.protobuf.v1.State;
import io.crossplane.compositefunctions.starter.exception.CrossplaneUnmarshallException;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossplaneObservableService {
    private static final Logger logger = LoggerFactory.getLogger(CrossplaneObservableService.class);
    private final JsonFormat.Printer printer = JsonFormat.printer();

    public <T> Optional<T> getObservableResource(String resourceName, State observedState, Class<T> clazz) {
        Resource observedResource = observedState.getResourcesOrDefault(resourceName, null);
        Optional<Object> result = Optional.empty();
        if (observedResource != null) {
            try {
                logger.debug("We have an observed " + clazz.getSimpleName());
                result = Optional.ofNullable(Serialization.unmarshal((String)this.printer.print((MessageOrBuilder)observedResource.getResource()), clazz));
            }
            catch (Exception e) {
                throw new CrossplaneUnmarshallException("Error when unmarshalling the observed resource " + clazz.getName(), e);
            }
        }
        return result;
    }

    public Map<String, String> getObservableConnectionDetails(String resourceName, State observedState) {
        Resource observedResource = observedState.getResourcesOrDefault(resourceName, null);
        HashMap<String, String> result = new HashMap<String, String>();
        if (observedResource != null) {
            try {
                logger.debug("We have an observed connectionDetails for " + resourceName);
                observedResource.getConnectionDetailsMap().forEach((key, value) -> result.put((String)key, value.toStringUtf8()));
            }
            catch (Exception e) {
                throw new CrossplaneUnmarshallException("Error when unmarshalling the connectionDetails for " + resourceName, e);
            }
        }
        return result;
    }
}

