/*
 * Decompiled with CFR 0.152.
 */
package io.crossplane.compositefunctions.starter.registration;

import io.crossplane.apiextensions.v1.CompositeResourceDefinition;
import io.crossplane.apiextensions.v1.CompositeResourceDefinitionSpec;
import io.crossplane.apiextensions.v1.Composition;
import io.crossplane.apiextensions.v1.CompositionSpec;
import io.crossplane.apiextensions.v1.compositeresourcedefinitionspec.ClaimNames;
import io.crossplane.apiextensions.v1.compositeresourcedefinitionspec.Names;
import io.crossplane.apiextensions.v1.compositeresourcedefinitionspec.Versions;
import io.crossplane.apiextensions.v1.compositeresourcedefinitionspec.versions.Schema;
import io.crossplane.apiextensions.v1.compositionspec.CompositeTypeRef;
import io.crossplane.apiextensions.v1.compositionspec.Pipeline;
import io.crossplane.apiextensions.v1.compositionspec.pipeline.FunctionRef;
import io.crossplane.compositefunctions.starter.registration.CrossplaneCompositeResourceMixin;
import io.crossplane.compositefunctions.starter.registration.CrossplaneJsonSchemaGenerator;
import io.crossplane.compositefunctions.starter.registration.CrossplaneMetadataBuilder;
import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.List;

public class CrossplaneCompositeResourceService {
    public static <T extends CustomResource<?, Void>> void registerOrUpdateCompositeResource(List<String> pipelineFunctions, T compositionDefinition, KubernetesClient kubernetesClient) {
        CompositeResourceDefinition compositeResourceDefinition = CrossplaneCompositeResourceService.createCompositeResourceDefinition(compositionDefinition);
        CrossplaneCompositeResourceService.registerOrUpdateCompositeResourceDefinition(compositeResourceDefinition, kubernetesClient);
        Composition composition = CrossplaneCompositeResourceService.createCompositionDefinition(pipelineFunctions, compositionDefinition);
        CrossplaneCompositeResourceService.registerOrUpdateCompositeResourceDefinition(composition, kubernetesClient);
    }

    private static void registerOrUpdateCompositeResourceDefinition(CompositeResourceDefinition compositeResourceDefinition, KubernetesClient kubernetesClient) {
        MixedOperation customResourceClient = kubernetesClient.resources(CompositeResourceDefinition.class);
        Resource resource = (Resource)customResourceClient.resource((Object)compositeResourceDefinition);
        CompositeResourceDefinition serverSide = (CompositeResourceDefinition)resource.get();
        if (serverSide == null) {
            resource.create();
        } else {
            resource.update();
        }
    }

    public static <T extends CustomResource<?, Void>> CompositeResourceDefinition createCompositeResourceDefinition(T compositionDefinition) {
        CompositeResourceDefinition compositeResourceDefinition = new CompositeResourceDefinition();
        CompositeResourceDefinitionSpec spec = new CompositeResourceDefinitionSpec();
        spec.setGroup(compositionDefinition.getGroup());
        String namePrefix = "";
        if (compositionDefinition instanceof Namespaced) {
            ClaimNames claimNames = new ClaimNames();
            claimNames.setKind(compositionDefinition.getKind());
            claimNames.setPlural(compositionDefinition.getPlural());
            claimNames.setSingular(compositionDefinition.getSingular());
            spec.setClaimNames(claimNames);
            namePrefix = "x";
        }
        Names names = new Names();
        names.setKind(namePrefix + compositionDefinition.getKind());
        names.setPlural(namePrefix + compositionDefinition.getPlural());
        names.setSingular(namePrefix + compositionDefinition.getSingular());
        spec.setNames(names);
        Versions versions = new Versions();
        versions.setName(compositionDefinition.getVersion());
        versions.setReferenceable(Boolean.valueOf(compositionDefinition.isStorage()));
        versions.setServed(Boolean.valueOf(compositionDefinition.isServed()));
        compositeResourceDefinition.setMetadata(CrossplaneMetadataBuilder.createMetadata(namePrefix + compositionDefinition.getCRDName()));
        Schema schema = new Schema();
        schema.setOpenAPIV3Schema(CrossplaneJsonSchemaGenerator.getOpenAPIV3Schema(compositionDefinition.getClass(), CrossplaneCompositeResourceMixin.class));
        versions.setSchema(schema);
        spec.setVersions(List.of(versions));
        compositeResourceDefinition.setSpec((Object)spec);
        return compositeResourceDefinition;
    }

    private static void registerOrUpdateCompositeResourceDefinition(Composition compositeResourceDefinition, KubernetesClient kubernetesClient) {
        MixedOperation customResourceClient = kubernetesClient.resources(Composition.class);
        Resource resource = (Resource)customResourceClient.resource((Object)compositeResourceDefinition);
        Composition serverSide = (Composition)resource.get();
        if (serverSide == null) {
            resource.create();
        } else {
            resource.update();
        }
    }

    private static <T extends CustomResource<?, Void>> Composition createCompositionDefinition(List<String> pipelineFunctions, T compositionDefinition) {
        Composition composition = new Composition();
        composition.setMetadata(CrossplaneMetadataBuilder.createMetadata(compositionDefinition.getKind().toLowerCase() + "-composition"));
        CompositionSpec compositionSpec = new CompositionSpec();
        CompositeTypeRef compositeTypeRef = new CompositeTypeRef();
        compositeTypeRef.setKind(compositionDefinition.getKind());
        compositeTypeRef.setApiVersion(compositionDefinition.getApiVersion());
        compositionSpec.setCompositeTypeRef(compositeTypeRef);
        compositionSpec.setMode(CompositionSpec.Mode.PIPELINE);
        ArrayList pipelineList = new ArrayList();
        pipelineFunctions.forEach(s -> pipelineList.add(CrossplaneCompositeResourceService.createPipeline(s)));
        compositionSpec.setPipeline(pipelineList);
        composition.setSpec((Object)compositionSpec);
        return composition;
    }

    private static Pipeline createPipeline(String pipelineName) {
        Pipeline pipeline = new Pipeline();
        pipeline.setStep(pipelineName);
        FunctionRef functionRef = new FunctionRef();
        functionRef.setName(pipelineName);
        pipeline.setFunctionRef(functionRef);
        return pipeline;
    }
}

