/*
 * Decompiled with CFR 0.152.
 */
package io.crossplane.compositefunctions.starter.registration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.module.jsonSchema.jakarta.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.jakarta.JsonSchemaGenerator;
import com.fasterxml.jackson.module.jsonSchema.jakarta.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.jakarta.factories.VisitorContext;
import com.fasterxml.jackson.module.jsonSchema.jakarta.types.ArraySchema;
import io.crossplane.apiextensions.v1.compositeresourcedefinitionspec.versions.schema.OpenAPIV3Schema;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import java.io.IOException;
import java.util.stream.Stream;

public class CrossplaneJsonSchemaGenerator {
    public static OpenAPIV3Schema getOpenAPIV3Schema(Class clazz, Class mixin) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.addMixIn(clazz, mixin);
            SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
            visitor.setVisitorContext(new VisitorContext(){

                public String addSeenSchemaUri(JavaType aSeenSchema) {
                    return this.javaTypeToUrn(aSeenSchema);
                }
            });
            JsonSchemaGenerator generator = new JsonSchemaGenerator(mapper, visitor);
            JsonSchema jsonSchema = generator.generateSchema(clazz);
            CrossplaneJsonSchemaGenerator.removeIdField(jsonSchema);
            String s = mapper.writeValueAsString((Object)jsonSchema);
            return (OpenAPIV3Schema)mapper.readValue(s, OpenAPIV3Schema.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate JSONSchema for class " + clazz.getSimpleName(), e);
        }
    }

    private static void removeIdField(JsonSchema jsonSchema) {
        jsonSchema.setId(null);
        if (JsonFormatTypes.OBJECT.equals((Object)jsonSchema.getType())) {
            jsonSchema.asObjectSchema().getProperties().forEach((key, value) -> CrossplaneJsonSchemaGenerator.removeIdField(value));
        } else if (JsonFormatTypes.ARRAY.equals((Object)jsonSchema.getType())) {
            ArraySchema.Items items = jsonSchema.asArraySchema().getItems();
            if (items.isArrayItems()) {
                Stream.of(items.asArrayItems().getJsonSchemas()).forEach(s -> CrossplaneJsonSchemaGenerator.removeIdField(s));
            } else {
                CrossplaneJsonSchemaGenerator.removeIdField(items.asSingleItems().getSchema());
            }
        }
    }

    public static JSONSchemaProps getJsonSchema(Class clazz) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.addMixIn(JSONSchemaProps.class, IdIgnorer.class);
            JsonSchemaGenerator generator = new JsonSchemaGenerator(mapper);
            JsonSchema jsonSchema = generator.generateSchema(clazz);
            String s = mapper.writeValueAsString((Object)jsonSchema);
            return (JSONSchemaProps)mapper.readValue(s, JSONSchemaProps.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate JSONSchema for class " + clazz.getSimpleName(), e);
        }
    }

    private abstract class IdIgnorer {
        @JsonIgnore
        String id;

        private IdIgnorer() {
        }

        @JsonIgnore
        abstract String getId();

        @JsonIgnore
        abstract void setId(String var1);
    }
}

