/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.createmeta;

import io.cucumber.createmeta.internal.com.eclipsesource.json.Json;
import io.cucumber.createmeta.internal.com.eclipsesource.json.JsonObject;
import io.cucumber.createmeta.internal.com.eclipsesource.json.JsonValue;
import io.cucumber.messages.Messages;
import io.cucumber.messages.ProtocolVersion;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateMeta {
    private static final JsonObject CI_DICT;
    private static final String JSON_PATH = "/io/cucumber/createmeta/ciDict.json";

    public static Messages.Meta createMeta(String toolName, String toolVersion, Map<String, String> env) {
        Messages.Meta.Builder metaBuilder = Messages.Meta.newBuilder().setRuntime(Messages.Meta.Product.newBuilder().setName(System.getProperty("java.vm.name")).setVersion(System.getProperty("java.vm.version"))).setImplementation(Messages.Meta.Product.newBuilder().setName(toolName).setVersion(toolVersion)).setOs(Messages.Meta.Product.newBuilder().setName(System.getProperty("os.name"))).setCpu(Messages.Meta.Product.newBuilder().setName(System.getProperty("os.arch")));
        ProtocolVersion.getVersion().ifPresent(arg_0 -> ((Messages.Meta.Builder)metaBuilder).setProtocolVersion(arg_0));
        Messages.Meta.CI ci = CreateMeta.detectCI(env);
        if (ci != null) {
            metaBuilder.setCi(ci);
        }
        return metaBuilder.build();
    }

    public static String removeUserInfoFromUrl(String value) {
        if (value == null) {
            return null;
        }
        try {
            URI uri = URI.create(value);
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toASCIIString();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return value;
        }
    }

    static Messages.Meta.CI detectCI(Map<String, String> env) {
        ArrayList<Messages.Meta.CI> detected = new ArrayList<Messages.Meta.CI>();
        for (JsonObject.Member envEntry : CI_DICT) {
            Messages.Meta.CI ci = CreateMeta.createCi(envEntry.getName(), envEntry.getValue().asObject(), env);
            if (ci == null) continue;
            detected.add(ci);
        }
        return detected.size() == 1 ? (Messages.Meta.CI)detected.get(0) : null;
    }

    private static Messages.Meta.CI createCi(String name, JsonObject ciSystem, Map<String, String> env) {
        String url = CreateMeta.evaluate(CreateMeta.getString(ciSystem, "url"), env);
        if (url == null) {
            return null;
        }
        JsonObject git = ciSystem.get("git").asObject();
        String remote = CreateMeta.removeUserInfoFromUrl(CreateMeta.evaluate(CreateMeta.getString(git, "remote"), env));
        String revision = CreateMeta.evaluate(CreateMeta.getString(git, "revision"), env);
        String branch = CreateMeta.evaluate(CreateMeta.getString(git, "branch"), env);
        String tag = CreateMeta.evaluate(CreateMeta.getString(git, "tag"), env);
        Messages.Meta.CI.Builder ciBuilder = Messages.Meta.CI.newBuilder().setName(name).setUrl(url);
        Messages.Meta.CI.Git.Builder gitBuilder = Messages.Meta.CI.Git.newBuilder();
        if (remote != null) {
            gitBuilder.setRemote(remote);
        }
        if (revision != null) {
            gitBuilder.setRevision(revision);
        }
        if (branch != null) {
            gitBuilder.setBranch(branch);
        }
        if (tag != null) {
            gitBuilder.setTag(tag);
        }
        return ciBuilder.setGit(gitBuilder).build();
    }

    private static String evaluate(String template, Map<String, String> env) {
        if (template == null) {
            return null;
        }
        try {
            Pattern pattern = Pattern.compile("\\$\\{((refbranch|reftag)\\s+)?([^\\s}]+)(\\s+\\|\\s+([^}]+))?}");
            Matcher matcher = pattern.matcher(template);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String defaultValue;
                String func = matcher.group(2);
                String variable = matcher.group(3);
                String value = env.getOrDefault(variable, defaultValue = matcher.group(5));
                if (value == null) {
                    throw new RuntimeException(String.format("Undefined variable: %s", variable));
                }
                if (func != null) {
                    switch (func) {
                        case "refbranch": {
                            value = CreateMeta.group1(value, Pattern.compile("^refs/heads/(.*)"));
                            break;
                        }
                        case "reftag": {
                            value = CreateMeta.group1(value, Pattern.compile("^refs/tags/(.*)"));
                        }
                    }
                }
                if (value == null) {
                    throw new RuntimeException(String.format("Undefined variable: %s", variable));
                }
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private static String group1(String value, Pattern pattern) {
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            String g1 = matcher.group(1);
            return g1;
        }
        return matcher.find() ? matcher.group(1) : null;
    }

    private static String getString(JsonObject json, String name) {
        JsonValue val = json.get(name);
        return val.isNull() ? null : val.asString();
    }

    static {
        try (InputStreamReader reader = new InputStreamReader(CreateMeta.class.getResourceAsStream(JSON_PATH), StandardCharsets.UTF_8);){
            CI_DICT = Json.parse(reader).asObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse /io/cucumber/createmeta/ciDict.json", e);
        }
    }
}

