/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.deltaspike;

import io.cucumber.core.backend.ObjectFactory;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.CdiContainerLoader;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DeltaSpikeObjectFactory
implements ObjectFactory {
    private final CdiContainer container = CdiContainerLoader.getCdiContainer();

    public void start() {
        this.container.boot();
    }

    public void stop() {
        this.container.shutdown();
    }

    public boolean addClass(Class<?> clazz) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getInstance(Class<T> type) {
        BeanManager beanManager = this.container.getBeanManager();
        Set beans = beanManager.getBeans(type, new Annotation[0]);
        Bean bean = beanManager.resolve(beans);
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)bean);
        try {
            T t = type.cast(beanManager.getReference(bean, type, creationalContext));
            return t;
        }
        finally {
            creationalContext.release();
        }
    }
}

