/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Argument;
import io.cucumber.cucumberexpressions.Ast;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.CucumberExpressionParser;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.Group;
import io.cucumber.cucumberexpressions.ParameterByTypeTransformer;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.cucumberexpressions.TreeRegexp;
import io.cucumber.cucumberexpressions.UndefinedParameterTypeException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class CucumberExpression
implements Expression {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("[\\\\^\\[({$.|?*+})\\]]");
    private final List<ParameterType<?>> parameterTypes = new ArrayList();
    private final String source;
    private final TreeRegexp treeRegexp;
    private final ParameterTypeRegistry parameterTypeRegistry;

    CucumberExpression(String expression, ParameterTypeRegistry parameterTypeRegistry) {
        this.source = expression;
        this.parameterTypeRegistry = parameterTypeRegistry;
        CucumberExpressionParser parser = new CucumberExpressionParser();
        Ast.Node ast = parser.parse(expression);
        String pattern = this.rewriteToRegex(ast);
        this.treeRegexp = new TreeRegexp(pattern);
    }

    private String rewriteToRegex(Ast.Node node) {
        switch (node.type()) {
            case TEXT_NODE: {
                return CucumberExpression.escapeRegex(node.text());
            }
            case OPTIONAL_NODE: {
                return this.rewriteOptional(node);
            }
            case ALTERNATION_NODE: {
                return this.rewriteAlternation(node);
            }
            case ALTERNATIVE_NODE: {
                return this.rewriteAlternative(node);
            }
            case PARAMETER_NODE: {
                return this.rewriteParameter(node);
            }
            case EXPRESSION_NODE: {
                return this.rewriteExpression(node);
            }
        }
        throw new IllegalArgumentException(node.type().name());
    }

    private static String escapeRegex(String text) {
        return ESCAPE_PATTERN.matcher(text).replaceAll("\\\\$0");
    }

    private String rewriteOptional(Ast.Node node) {
        this.assertNoParameters(node, astNode -> CucumberExpressionException.createParameterIsNotAllowedInOptional(astNode, this.source));
        this.assertNoOptionals(node, astNode -> CucumberExpressionException.createOptionalIsNotAllowedInOptional(astNode, this.source));
        this.assertNotEmpty(node, astNode -> CucumberExpressionException.createOptionalMayNotBeEmpty(astNode, this.source));
        return node.nodes().stream().map(this::rewriteToRegex).collect(Collectors.joining("", "(?:", ")?"));
    }

    private String rewriteAlternation(Ast.Node node) {
        for (Ast.Node alternative : node.nodes()) {
            if (alternative.nodes().isEmpty()) {
                throw CucumberExpressionException.createAlternativeMayNotBeEmpty(alternative, this.source);
            }
            this.assertNotEmpty(alternative, astNode -> CucumberExpressionException.createAlternativeMayNotExclusivelyContainOptionals(astNode, this.source));
        }
        return node.nodes().stream().map(this::rewriteToRegex).collect(Collectors.joining("|", "(?:", ")"));
    }

    private String rewriteAlternative(Ast.Node node) {
        return node.nodes().stream().map(this::rewriteToRegex).collect(Collectors.joining());
    }

    private String rewriteParameter(Ast.Node node) {
        String name = node.text();
        ParameterType parameterType = this.parameterTypeRegistry.lookupByTypeName(name);
        if (parameterType == null) {
            throw UndefinedParameterTypeException.createUndefinedParameterType(node, this.source, name);
        }
        this.parameterTypes.add(parameterType);
        List<String> regexps = parameterType.getRegexps();
        if (regexps.size() == 1) {
            return "(" + regexps.get(0) + ")";
        }
        return regexps.stream().collect(Collectors.joining(")|(?:", "((?:", "))"));
    }

    private String rewriteExpression(Ast.Node node) {
        return node.nodes().stream().map(this::rewriteToRegex).collect(Collectors.joining("", "^", "$"));
    }

    private void assertNotEmpty(Ast.Node node, Function<Ast.Node, CucumberExpressionException> createNodeWasNotEmptyException) {
        node.nodes().stream().filter(astNode -> Ast.Node.Type.TEXT_NODE.equals((Object)astNode.type())).findFirst().orElseThrow(() -> (CucumberExpressionException)createNodeWasNotEmptyException.apply(node));
    }

    private void assertNoParameters(Ast.Node node, Function<Ast.Node, CucumberExpressionException> createNodeContainedAParameterException) {
        this.assertNoNodeOfType(Ast.Node.Type.PARAMETER_NODE, node, createNodeContainedAParameterException);
    }

    private void assertNoOptionals(Ast.Node node, Function<Ast.Node, CucumberExpressionException> createNodeContainedAnOptionalException) {
        this.assertNoNodeOfType(Ast.Node.Type.OPTIONAL_NODE, node, createNodeContainedAnOptionalException);
    }

    private void assertNoNodeOfType(Ast.Node.Type nodeType, Ast.Node node, Function<Ast.Node, CucumberExpressionException> createException) {
        node.nodes().stream().filter(astNode -> nodeType.equals((Object)astNode.type())).map(createException).findFirst().ifPresent(exception -> {
            throw exception;
        });
    }

    @Override
    public List<Argument<?>> match(String text, Type ... typeHints) {
        Group group = this.treeRegexp.match(text);
        if (group == null) {
            return null;
        }
        ArrayList parameterTypes = new ArrayList(this.parameterTypes);
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Class<String> type;
            ParameterType parameterType = (ParameterType)parameterTypes.get(i);
            Class<String> clazz = type = i < typeHints.length ? typeHints[i] : String.class;
            if (!parameterType.isAnonymous()) continue;
            ParameterByTypeTransformer defaultTransformer = this.parameterTypeRegistry.getDefaultParameterTransformer();
            parameterTypes.set(i, parameterType.deAnonymize((Type)((Object)type), arg -> defaultTransformer.transform(arg, (Type)((Object)type))));
        }
        return Argument.build(group, parameterTypes);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Pattern getRegexp() {
        return this.treeRegexp.pattern();
    }
}

