/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.AmbiguousParameterTypeException;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.CucumberExpressionGenerator;
import io.cucumber.cucumberexpressions.DuplicateTypeNameException;
import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.NumberParser;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.Transformer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class ParameterTypeRegistry {
    private static final List<String> INTEGER_REGEXPS = Arrays.asList(Pattern.compile("-?\\d+").pattern(), Pattern.compile("\\d+").pattern());
    private static final List<String> FLOAT_REGEXPS = Collections.singletonList(Pattern.compile("-?\\d*[.,]\\d+").pattern());
    private static final List<String> WORD_REGEXPS = Collections.singletonList(Pattern.compile("\\w+").pattern());
    private static final List<String> STRING_REGEXPS = Collections.singletonList(Pattern.compile("\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"|'([^'\\\\]*(\\\\.[^'\\\\]*)*)'").pattern());
    private final Map<String, ParameterType<?>> parameterTypeByName = new HashMap();
    private final Map<String, SortedSet<ParameterType<?>>> parameterTypesByRegexp = new HashMap();

    public ParameterTypeRegistry(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        final NumberParser numberParser = new NumberParser(numberFormat);
        this.defineParameterType(new ParameterType<BigInteger>("biginteger", INTEGER_REGEXPS, BigInteger.class, new Transformer<BigInteger>(){

            @Override
            public BigInteger transform(String arg) {
                return arg == null ? null : new BigInteger(arg);
            }
        }, false, false));
        this.defineParameterType(new ParameterType<BigDecimal>("bigdecimal", FLOAT_REGEXPS, BigDecimal.class, new Transformer<BigDecimal>(){

            @Override
            public BigDecimal transform(String arg) {
                return arg == null ? null : new BigDecimal(arg);
            }
        }, false, false));
        this.defineParameterType(new ParameterType<Byte>("byte", INTEGER_REGEXPS, Byte.class, new Transformer<Byte>(){

            @Override
            public Byte transform(String arg) {
                return arg == null ? null : Byte.decode(arg);
            }
        }, false, false));
        this.defineParameterType(new ParameterType<Short>("short", INTEGER_REGEXPS, Short.class, new Transformer<Short>(){

            @Override
            public Short transform(String arg) {
                return arg == null ? null : Short.decode(arg);
            }
        }, false, false));
        this.defineParameterType(new ParameterType<Integer>("int", INTEGER_REGEXPS, Integer.class, new Transformer<Integer>(){

            @Override
            public Integer transform(String arg) {
                return arg == null ? null : Integer.decode(arg);
            }
        }, true, true));
        this.defineParameterType(new ParameterType<Long>("long", INTEGER_REGEXPS, Long.class, new Transformer<Long>(){

            @Override
            public Long transform(String arg) {
                return arg == null ? null : Long.decode(arg);
            }
        }, false, false));
        this.defineParameterType(new ParameterType<Float>("float", FLOAT_REGEXPS, Float.class, new Transformer<Float>(){

            @Override
            public Float transform(String arg) {
                return arg == null ? null : Float.valueOf(numberParser.parseFloat(arg));
            }
        }, false, false));
        this.defineParameterType(new ParameterType<Double>("double", FLOAT_REGEXPS, Double.class, new Transformer<Double>(){

            @Override
            public Double transform(String arg) {
                return arg == null ? null : Double.valueOf(numberParser.parseDouble(arg));
            }
        }, true, true));
        this.defineParameterType(new ParameterType<String>("word", WORD_REGEXPS, String.class, new Transformer<String>(){

            @Override
            public String transform(String arg) {
                return arg;
            }
        }, false, false));
        this.defineParameterType(new ParameterType<String>("string", STRING_REGEXPS, String.class, new Transformer<String>(){

            @Override
            public String transform(String arg) {
                return arg == null ? null : arg.replaceAll("\\\\\"", "\"").replaceAll("\\\\'", "'");
            }
        }, true, false));
    }

    public void defineParameterType(ParameterType<?> parameterType) {
        if (parameterType.getName() != null) {
            if (this.parameterTypeByName.containsKey(parameterType.getName())) {
                throw new DuplicateTypeNameException(String.format("There is already a parameter type with name %s", parameterType.getName()));
            }
            this.parameterTypeByName.put(parameterType.getName(), parameterType);
        }
        for (String parameterTypeRegexp : parameterType.getRegexps()) {
            SortedSet<ParameterType<?>> parameterTypes;
            if (this.parameterTypesByRegexp.get(parameterTypeRegexp) == null) {
                this.parameterTypesByRegexp.put(parameterTypeRegexp, new TreeSet());
            }
            if (!(parameterTypes = this.parameterTypesByRegexp.get(parameterTypeRegexp)).isEmpty() && parameterTypes.first().preferForRegexpMatch() && parameterType.preferForRegexpMatch()) {
                throw new CucumberExpressionException(String.format("There can only be one preferential parameter type per regexp. The regexp /%s/ is used for two preferential parameter types, {%s} and {%s}", parameterTypeRegexp, parameterTypes.first().getName(), parameterType.getName()));
            }
            parameterTypes.add(parameterType);
        }
    }

    public <T> ParameterType<T> lookupByTypeName(String typeName) {
        return this.parameterTypeByName.get(typeName);
    }

    public <T> ParameterType<T> lookupByRegexp(String parameterTypeRegexp, Pattern expressionRegexp, String text) {
        SortedSet<ParameterType<?>> parameterTypes = this.parameterTypesByRegexp.get(parameterTypeRegexp);
        if (parameterTypes == null) {
            return null;
        }
        if (parameterTypes.size() > 1 && !parameterTypes.first().preferForRegexpMatch()) {
            List<GeneratedExpression> generatedExpressions = new CucumberExpressionGenerator(this).generateExpressions(text);
            throw new AmbiguousParameterTypeException(parameterTypeRegexp, expressionRegexp, parameterTypes, generatedExpressions);
        }
        return parameterTypes.first();
    }

    public Collection<ParameterType<?>> getParameterTypes() {
        return this.parameterTypeByName.values();
    }
}

