/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.NumberParser;
import io.cucumber.cucumberexpressions.ParameterByTypeTransformer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import java.util.Objects;

final class BuiltInParameterTransformer
implements ParameterByTypeTransformer {
    private final NumberParser numberParser;

    BuiltInParameterTransformer(Locale locale) {
        this.numberParser = new NumberParser(locale);
    }

    @Override
    public Object transform(String fromValue, Type toValueType) {
        if (!(toValueType instanceof Class)) {
            throw this.createIllegalArgumentException(fromValue, toValueType);
        }
        Class toValueClass = (Class)Objects.requireNonNull(toValueType);
        if (fromValue == null) {
            return null;
        }
        if (String.class.equals((Object)toValueClass) || Object.class.equals((Object)toValueClass)) {
            return fromValue;
        }
        if (BigInteger.class.equals((Object)toValueClass)) {
            return new BigInteger(fromValue);
        }
        if (BigDecimal.class.equals((Object)toValueClass)) {
            return this.numberParser.parseBigDecimal(fromValue);
        }
        if (Byte.class.equals((Object)toValueClass) || Byte.TYPE.equals(toValueClass)) {
            return Byte.decode(fromValue);
        }
        if (Short.class.equals((Object)toValueClass) || Short.TYPE.equals(toValueClass)) {
            return Short.decode(fromValue);
        }
        if (Integer.class.equals((Object)toValueClass) || Integer.TYPE.equals(toValueClass)) {
            return Integer.decode(fromValue);
        }
        if (Long.class.equals((Object)toValueClass) || Long.TYPE.equals(toValueClass)) {
            return Long.decode(fromValue);
        }
        if (Float.class.equals((Object)toValueClass) || Float.TYPE.equals(toValueClass)) {
            return Float.valueOf(this.numberParser.parseFloat(fromValue));
        }
        if (Double.class.equals((Object)toValueClass) || Double.TYPE.equals(toValueClass)) {
            return this.numberParser.parseDouble(fromValue);
        }
        if (Boolean.class.equals((Object)toValueClass) || Boolean.TYPE.equals(toValueClass)) {
            return Boolean.parseBoolean(fromValue);
        }
        if (toValueClass.isEnum()) {
            Class enumClass = toValueClass;
            for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
                if (!enumConstant.name().equals(fromValue)) continue;
                return enumConstant;
            }
            throw new CucumberExpressionException("Can't transform '" + fromValue + "' to " + toValueType + ". Not an enum constant");
        }
        throw this.createIllegalArgumentException(fromValue, toValueType);
    }

    private IllegalArgumentException createIllegalArgumentException(String fromValue, Type toValueType) {
        return new IllegalArgumentException("Can't transform '" + fromValue + "' to " + toValueType + "\nBuiltInParameterTransformer only supports a limited number of class types\nConsider using a different object mapper or register a parameter type for " + toValueType);
    }
}

