/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CaptureGroupTransformer;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.Transformer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class ParameterType<T>
implements Comparable<ParameterType<?>> {
    private static final Pattern ILLEGAL_PARAMETER_NAME_PATTERN = Pattern.compile("([\\[\\]()$.|?*+])");
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile("(\\\\([\\[$.|?*+\\]]))");
    private final String name;
    private final Type type;
    private final List<String> regexps;
    private final boolean preferForRegexpMatch;
    private final boolean useForSnippets;
    private final CaptureGroupTransformer<T> transformer;
    private final boolean anonymous;
    private final boolean useRegexpMatchAsStrongTypeHint;

    static void checkParameterTypeName(String name) {
        String unescapedTypeName = UNESCAPE_PATTERN.matcher(name).replaceAll("$2");
        Matcher matcher = ILLEGAL_PARAMETER_NAME_PATTERN.matcher(unescapedTypeName);
        if (matcher.find()) {
            throw new CucumberExpressionException(String.format("Illegal character '%s' in parameter name {%s}.", matcher.group(1), unescapedTypeName));
        }
    }

    static ParameterType<Object> createAnonymousParameterType(String regexp) {
        return new ParameterType<Object>("", Collections.singletonList(regexp), (Type)((Object)Object.class), new CaptureGroupTransformer<Object>(){

            @Override
            public Object transform(String[] arg) {
                throw new UnsupportedOperationException("Anonymous transform must be deanonymized before use");
            }
        }, false, true, false, true);
    }

    static <E extends Enum> ParameterType<E> fromEnum(Class<E> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        StringBuilder regexpBuilder = new StringBuilder();
        for (int i = 0; i < enumConstants.length; ++i) {
            if (i > 0) {
                regexpBuilder.append("|");
            }
            regexpBuilder.append(enumConstants[i].name());
        }
        return new ParameterType<Enum>(enumClass.getSimpleName(), regexpBuilder.toString(), enumClass, arg -> Enum.valueOf(enumClass, arg));
    }

    private ParameterType(String name, List<String> regexps, Type type, CaptureGroupTransformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch, boolean useRegexpMatchAsStrongTypeHint, boolean anonymous) {
        if (regexps == null) {
            throw new NullPointerException("regexps cannot be null");
        }
        if (type == null) {
            throw new NullPointerException("type cannot be null");
        }
        if (transformer == null) {
            throw new NullPointerException("transformer cannot be null");
        }
        if (name != null) {
            ParameterType.checkParameterTypeName(name);
        }
        this.name = name;
        this.regexps = regexps;
        this.type = type;
        this.transformer = transformer;
        this.useForSnippets = useForSnippets;
        this.preferForRegexpMatch = preferForRegexpMatch;
        this.anonymous = anonymous;
        this.useRegexpMatchAsStrongTypeHint = useRegexpMatchAsStrongTypeHint;
    }

    public ParameterType(String name, List<String> regexps, Type type, CaptureGroupTransformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch, boolean useRegexpMatchAsStrongTypeHint) {
        this(name, regexps, type, transformer, useForSnippets, preferForRegexpMatch, useRegexpMatchAsStrongTypeHint, false);
    }

    public ParameterType(String name, List<String> regexps, Type type, CaptureGroupTransformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, regexps, type, transformer, useForSnippets, preferForRegexpMatch, true);
    }

    public ParameterType(String name, List<String> regexps, Class<T> type, CaptureGroupTransformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, regexps, (Type)type, transformer, useForSnippets, preferForRegexpMatch);
    }

    public ParameterType(String name, String regexp, Class<T> type, CaptureGroupTransformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, Collections.singletonList(regexp), type, transformer, useForSnippets, preferForRegexpMatch);
    }

    public ParameterType(String name, List<String> regexps, Class<T> type, CaptureGroupTransformer<T> transformer) {
        this(name, regexps, type, transformer, true, false);
    }

    public ParameterType(String name, String regexp, Class<T> type, CaptureGroupTransformer<T> transformer) {
        this(name, Collections.singletonList(regexp), type, transformer, true, false);
    }

    public ParameterType(String name, List<String> regexps, Type type, Transformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch, boolean useRegexpMatchAsStrongTypeHint) {
        this(name, regexps, type, new TransformerAdaptor(transformer), useForSnippets, preferForRegexpMatch, useRegexpMatchAsStrongTypeHint);
    }

    public ParameterType(String name, List<String> regexps, Type type, Transformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, regexps, type, new TransformerAdaptor(transformer), useForSnippets, preferForRegexpMatch);
    }

    public ParameterType(String name, List<String> regexps, Class<T> type, Transformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch, boolean useRegexpMatchAsStrongTypeHint) {
        this(name, regexps, (Type)type, transformer, useForSnippets, preferForRegexpMatch, useRegexpMatchAsStrongTypeHint);
    }

    public ParameterType(String name, List<String> regexps, Class<T> type, Transformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, regexps, (Type)type, transformer, useForSnippets, preferForRegexpMatch);
    }

    public ParameterType(String name, String regexp, Class<T> type, Transformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch, boolean useRegexpMatchAsStrongTypeHint) {
        this(name, Collections.singletonList(regexp), type, transformer, useForSnippets, preferForRegexpMatch, useRegexpMatchAsStrongTypeHint);
    }

    public ParameterType(String name, String regexp, Class<T> type, Transformer<T> transformer, boolean useForSnippets, boolean preferForRegexpMatch) {
        this(name, Collections.singletonList(regexp), type, transformer, useForSnippets, preferForRegexpMatch);
    }

    public ParameterType(String name, List<String> regexps, Class<T> type, Transformer<T> transformer) {
        this(name, regexps, type, transformer, true, false);
    }

    public ParameterType(String name, String regexp, Class<T> type, Transformer<T> transformer) {
        this(name, Collections.singletonList(regexp), type, transformer, true, false);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public List<String> getRegexps() {
        return this.regexps;
    }

    public boolean preferForRegexpMatch() {
        return this.preferForRegexpMatch;
    }

    public boolean useForSnippets() {
        return this.useForSnippets;
    }

    boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean useRegexpMatchAsStrongTypeHint() {
        return this.useRegexpMatchAsStrongTypeHint;
    }

    ParameterType<Object> deAnonymize(Type type, Transformer<Object> transformer) {
        return new ParameterType<Object>("anonymous", this.regexps, type, new TransformerAdaptor(transformer), this.useForSnippets, this.preferForRegexpMatch, this.useRegexpMatchAsStrongTypeHint, this.anonymous);
    }

    T transform(List<String> groupValues) {
        if (this.transformer instanceof TransformerAdaptor && groupValues.size() > 1) {
            if (this.isAnonymous()) {
                throw new CucumberExpressionException(String.format("Anonymous ParameterType has multiple capture groups %s. You can only use a single capture group in an anonymous ParameterType.", this.regexps));
            }
            throw new CucumberExpressionException(String.format("ParameterType {%s} was registered with a Transformer but has multiple capture groups %s. Did you mean to use a CaptureGroupTransformer?", this.name, this.regexps));
        }
        try {
            String[] groupValueArray = groupValues.toArray(new String[0]);
            return this.transformer.transform(groupValueArray);
        }
        catch (CucumberExpressionException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new CucumberExpressionException(String.format("ParameterType {%s} failed to transform %s to %s", this.name, groupValues, this.type), throwable);
        }
    }

    @Override
    public int compareTo(ParameterType<?> o) {
        if (this.preferForRegexpMatch() && !o.preferForRegexpMatch()) {
            return -1;
        }
        if (o.preferForRegexpMatch() && !this.preferForRegexpMatch()) {
            return 1;
        }
        String name = this.getName() != null ? this.getName() : "";
        String otherName = o.getName() != null ? o.getName() : "";
        return name.compareTo(otherName);
    }

    public int weight() {
        if (this.type.equals(Integer.class) || this.type.equals(Integer.TYPE)) {
            return 1000;
        }
        return 0;
    }

    private static final class TransformerAdaptor<T>
    implements CaptureGroupTransformer<T> {
        private final Transformer<T> transformer;

        private TransformerAdaptor(Transformer<T> transformer) {
            if (transformer == null) {
                throw new NullPointerException("transformer cannot be null");
            }
            this.transformer = transformer;
        }

        @Override
        public T transform(String[] args) throws Throwable {
            String arg = args.length == 0 ? null : args[0];
            return this.transformer.transform(arg);
        }
    }
}

