/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.messages.Messages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class CucumberQuery {
    private final Map<String, Messages.GherkinDocument.Feature.Step> gherkinStepById = new HashMap<String, Messages.GherkinDocument.Feature.Step>();
    private final Map<String, Messages.GherkinDocument.Feature.Scenario> gherkinScenarioById = new HashMap<String, Messages.GherkinDocument.Feature.Scenario>();
    private final Map<String, Messages.Location> locationBySourceId = new HashMap<String, Messages.Location>();

    CucumberQuery() {
    }

    void update(Messages.GherkinDocument gherkinDocument) {
        for (Messages.GherkinDocument.Feature.FeatureChild featureChild : gherkinDocument.getFeature().getChildrenList()) {
            if (featureChild.hasBackground()) {
                this.updateBackground(featureChild.getBackground(), gherkinDocument.getUri());
            }
            if (featureChild.hasScenario()) {
                this.updateScenario(featureChild.getScenario(), gherkinDocument.getUri());
            }
            if (!featureChild.hasRule()) continue;
            for (Messages.GherkinDocument.Feature.FeatureChild.RuleChild ruleChild : featureChild.getRule().getChildrenList()) {
                if (ruleChild.hasBackground()) {
                    this.updateBackground(ruleChild.getBackground(), gherkinDocument.getUri());
                }
                if (!ruleChild.hasScenario()) continue;
                this.updateScenario(ruleChild.getScenario(), gherkinDocument.getUri());
            }
        }
    }

    private void updateBackground(Messages.GherkinDocument.Feature.Background background, String uri) {
        this.updateStep(background.getStepsList());
    }

    private void updateScenario(Messages.GherkinDocument.Feature.Scenario scenario, String uri) {
        this.gherkinScenarioById.put(Objects.requireNonNull(scenario.getId()), scenario);
        this.locationBySourceId.put(Objects.requireNonNull(scenario.getId()), scenario.getLocation());
        this.updateStep(scenario.getStepsList());
        for (Messages.GherkinDocument.Feature.Scenario.Examples examples : scenario.getExamplesList()) {
            for (Messages.GherkinDocument.Feature.TableRow tableRow : examples.getTableBodyList()) {
                this.locationBySourceId.put(Objects.requireNonNull(tableRow.getId()), tableRow.getLocation());
            }
        }
    }

    private void updateStep(List<Messages.GherkinDocument.Feature.Step> stepsList) {
        for (Messages.GherkinDocument.Feature.Step step : stepsList) {
            this.locationBySourceId.put(Objects.requireNonNull(step.getId()), step.getLocation());
            this.gherkinStepById.put(Objects.requireNonNull(step.getId()), step);
        }
    }

    Messages.GherkinDocument.Feature.Step getGherkinStep(String sourceId) {
        return Objects.requireNonNull(this.gherkinStepById.get(Objects.requireNonNull(sourceId)));
    }

    Messages.GherkinDocument.Feature.Scenario getGherkinScenario(String sourceId) {
        return Objects.requireNonNull(this.gherkinScenarioById.get(Objects.requireNonNull(sourceId)));
    }

    Messages.Location getLocation(String sourceId) {
        Messages.Location location = this.locationBySourceId.get(Objects.requireNonNull(sourceId));
        return Objects.requireNonNull(location);
    }
}

