/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.Step;
import io.cucumber.core.gherkin.StepType;
import io.cucumber.core.gherkin.messages.CucumberQuery;
import io.cucumber.core.gherkin.messages.GherkinMessagesLocation;
import io.cucumber.core.gherkin.messages.GherkinMessagesStep;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDialect;
import io.cucumber.messages.Messages;
import io.cucumber.messages.internal.com.google.protobuf.ProtocolStringList;
import io.cucumber.plugin.event.Location;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

final class GherkinMessagesPickle
implements Pickle {
    private final Messages.Pickle pickle;
    private final List<Step> steps;
    private final URI uri;
    private final CucumberQuery cucumberQuery;

    GherkinMessagesPickle(Messages.Pickle pickle, URI uri, GherkinDialect dialect, CucumberQuery cucumberQuery) {
        this.pickle = pickle;
        this.uri = uri;
        this.cucumberQuery = cucumberQuery;
        this.steps = GherkinMessagesPickle.createCucumberSteps(pickle, dialect, this.cucumberQuery);
    }

    private static List<Step> createCucumberSteps(Messages.Pickle pickle, GherkinDialect dialect, CucumberQuery cucumberQuery) {
        ArrayList<Step> list = new ArrayList<Step>();
        String previousGivenWhenThen = dialect.getGivenKeywords().stream().filter(s -> !StepType.isAstrix((String)s)).findFirst().orElseThrow(() -> new IllegalStateException("No Given keyword for dialect: " + dialect.getName()));
        for (Messages.Pickle.PickleStep pickleStep : pickle.getStepsList()) {
            String keyword;
            String gherkinStepId;
            Messages.GherkinDocument.Feature.Step gherkinStep;
            Messages.Location location;
            GherkinMessagesStep step = new GherkinMessagesStep(pickleStep, dialect, previousGivenWhenThen, location = (gherkinStep = cucumberQuery.getGherkinStep(gherkinStepId = pickleStep.getAstNodeIds(0))).getLocation(), keyword = gherkinStep.getKeyword());
            if (step.getType().isGivenWhenThen()) {
                previousGivenWhenThen = step.getKeyword();
            }
            list.add(step);
        }
        return list;
    }

    public String getKeyword() {
        return this.cucumberQuery.getGherkinScenario(this.pickle.getAstNodeIds(0)).getKeyword();
    }

    public String getLanguage() {
        return this.pickle.getLanguage();
    }

    public String getName() {
        return this.pickle.getName();
    }

    public Location getLocation() {
        ProtocolStringList sourceIds = this.pickle.getAstNodeIdsList();
        String sourceId = (String)sourceIds.get(sourceIds.size() - 1);
        Messages.Location location = this.cucumberQuery.getLocation(sourceId);
        return GherkinMessagesLocation.from(location);
    }

    public Location getScenarioLocation() {
        String sourceId = this.pickle.getAstNodeIds(0);
        Messages.GherkinDocument.Feature.Scenario scenario = this.cucumberQuery.getGherkinScenario(sourceId);
        Messages.Location location = scenario.getLocation();
        return GherkinMessagesLocation.from(location);
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public List<String> getTags() {
        return this.pickle.getTagsList().stream().map(Messages.Pickle.PickleTag::getName).collect(Collectors.toList());
    }

    public URI getUri() {
        return this.uri;
    }

    public String getId() {
        return this.pickle.getId();
    }
}

