/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.FeatureParser;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.messages.CucumberQuery;
import io.cucumber.core.gherkin.messages.GherkinMessagesFeature;
import io.cucumber.core.gherkin.messages.GherkinMessagesPickle;
import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinDialectProvider;
import io.cucumber.gherkin.GherkinParser;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.ParseError;
import io.cucumber.messages.types.Source;
import io.cucumber.messages.types.SourceMediaType;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class GherkinMessagesFeatureParser
implements FeatureParser {
    public Optional<Feature> parse(URI path, String source, Supplier<UUID> idGenerator) {
        List envelopes = GherkinParser.builder().idGenerator(() -> ((UUID)idGenerator.get()).toString()).build().parse(Envelope.of((Source)new Source(path.toString(), source, SourceMediaType.TEXT_X_CUCUMBER_GHERKIN_PLAIN))).collect(Collectors.toList());
        List errors = envelopes.stream().map(Envelope::getParseError).filter(Optional::isPresent).map(Optional::get).map(ParseError::getMessage).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new FeatureParserException("Failed to parse resource at: " + path + "\n" + String.join((CharSequence)"\n", errors));
        }
        return envelopes.stream().map(Envelope::getGherkinDocument).filter(Optional::isPresent).map(Optional::get).findFirst().map(GherkinDocument::getFeature).filter(Optional::isPresent).map(Optional::get).map(feature -> {
            CucumberQuery cucumberQuery = new CucumberQuery();
            cucumberQuery.update((io.cucumber.messages.types.Feature)feature);
            GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
            String language = feature.getLanguage();
            GherkinDialect dialect = dialectProvider.getDialect(language, null);
            List pickleMessages = envelopes.stream().map(Envelope::getPickle).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            List<Pickle> pickles = pickleMessages.stream().map(pickle -> new GherkinMessagesPickle((io.cucumber.messages.types.Pickle)pickle, path, dialect, cucumberQuery)).collect(Collectors.toList());
            return new GherkinMessagesFeature((io.cucumber.messages.types.Feature)feature, path, source, pickles, envelopes);
        });
    }

    public String version() {
        return "8";
    }
}

