/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.groovy;

import groovy.lang.GroovyObject;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Tuple;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.runtime.MetaClassHelper;

class GroovyWorld
extends GroovyObjectSupport {
    private final List<GroovyObject> worlds = new LinkedList<GroovyObject>();

    public void registerWorld(Object world) {
        if (!(world instanceof GroovyObject)) {
            throw new RuntimeException("Only GroovyObject supported");
        }
        this.worlds.add((GroovyObject)world);
    }

    public Object getProperty(String property) {
        return this.findWorldWithProperty(property).getProperty(property);
    }

    public void setProperty(String property, Object newValue) {
        this.findWorldWithProperty(property).setProperty(property, newValue);
    }

    public Object invokeMethod(String name, Object args) {
        return this.findWorldWithMethod(name, args).invokeMethod(name, args);
    }

    int worldsCount() {
        return this.worlds.size();
    }

    private GroovyObject findWorldWithProperty(String property) {
        if (this.worlds.isEmpty()) {
            throw new MissingPropertyException(property, GroovyWorld.class);
        }
        if (this.worlds.size() == 1) {
            return this.worlds.get(0);
        }
        GroovyObject worldWithProperty = null;
        for (GroovyObject world : this.worlds) {
            if (world.getMetaClass().hasProperty((Object)this, property) == null) continue;
            if (worldWithProperty == null) {
                worldWithProperty = world;
                continue;
            }
            throw new RuntimeException("Multiple property call: " + property);
        }
        if (worldWithProperty == null) {
            throw new MissingPropertyException(property, GroovyWorld.class);
        }
        return worldWithProperty;
    }

    private GroovyObject findWorldWithMethod(String methodName, Object arguments) {
        Object[] args = this.unwrapMethodArguments(arguments);
        if (this.worlds.isEmpty()) {
            throw new MissingMethodException(methodName, ((Object)((Object)this)).getClass(), args);
        }
        if (this.worlds.size() == 1) {
            return this.worlds.get(0);
        }
        GroovyObject worldWithMethod = null;
        for (GroovyObject world : this.worlds) {
            if (world.getMetaClass().getMetaMethod(methodName, args) == null) continue;
            if (worldWithMethod == null) {
                worldWithMethod = world;
                continue;
            }
            throw new RuntimeException("Multiple method call: " + methodName);
        }
        if (worldWithMethod == null) {
            throw new MissingMethodException(methodName, ((Object)((Object)this)).getClass(), args);
        }
        return worldWithMethod;
    }

    private Object[] unwrapMethodArguments(Object arguments) {
        if (arguments == null) {
            return MetaClassHelper.EMPTY_ARRAY;
        }
        if (arguments instanceof Tuple) {
            Tuple tuple = (Tuple)arguments;
            return tuple.toArray();
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }
}

