/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import io.cucumber.core.backend.Located;
import io.cucumber.core.backend.Lookup;
import io.cucumber.groovy.MethodFormat;
import java.lang.reflect.Method;
import java.util.Objects;

abstract class AbstractParamGlueDefinition
implements Located {
    protected final Method method;
    protected final Lookup lookup;
    private String fullFormat;

    AbstractParamGlueDefinition(Method method, Lookup lookup) {
        this.method = Objects.requireNonNull(method);
        this.lookup = Objects.requireNonNull(lookup);
    }

    public boolean isDefinedAt(StackTraceElement e) {
        return e.getClassName().equals(this.method.getDeclaringClass().getName()) && e.getMethodName().equals(this.method.getName());
    }

    public final String getLocation() {
        return this.getFullLocationLocation();
    }

    private String getFullLocationLocation() {
        if (this.fullFormat == null) {
            this.fullFormat = MethodFormat.FULL.format(this.method);
        }
        return this.fullFormat;
    }
}

