/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.Container;
import io.cucumber.core.backend.DataTableTypeDefinition;
import io.cucumber.core.backend.DefaultDataTableCellTransformerDefinition;
import io.cucumber.core.backend.DefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.backend.DefaultParameterTransformerDefinition;
import io.cucumber.core.backend.DocStringTypeDefinition;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.ParameterTypeDefinition;
import io.cucumber.core.backend.Snippet;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.core.exception.CucumberException;
import io.cucumber.core.resource.ClasspathScanner;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.core.resource.ResourceScanner;
import io.cucumber.groovy.DataTableType;
import io.cucumber.groovy.DefaultDataTableCellTransformer;
import io.cucumber.groovy.DefaultDataTableEntryTransformer;
import io.cucumber.groovy.DefaultParameterTransformer;
import io.cucumber.groovy.DocStringType;
import io.cucumber.groovy.GroovyDataTableTypeDefinition;
import io.cucumber.groovy.GroovyDefaultDataTableCellTransformerDefinition;
import io.cucumber.groovy.GroovyDefaultDataTableEntryTransformerDefinition;
import io.cucumber.groovy.GroovyDefaultParameterTransformerDefinition;
import io.cucumber.groovy.GroovyDocStringTypeDefinition;
import io.cucumber.groovy.GroovyHookDefinition;
import io.cucumber.groovy.GroovyParameterTypeDefinition;
import io.cucumber.groovy.GroovyScriptIdentifier;
import io.cucumber.groovy.GroovySnippet;
import io.cucumber.groovy.GroovyStepDefinition;
import io.cucumber.groovy.GroovyWorld;
import io.cucumber.groovy.MethodScanner;
import io.cucumber.groovy.ParameterType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.codehaus.groovy.control.CompilerConfiguration;

public class GroovyBackend
implements Backend {
    private static ThreadLocal<GroovyBackend> instanceThreadLocal = new ThreadLocal();
    private final Set<Class> scripts = new HashSet<Class>();
    private final ResourceScanner<Script> resourceLoader;
    private final GroovyShell shell;
    private final ClasspathScanner classFinder;
    private final Lookup lookup;
    private final Container container;
    private Collection<Closure> worldClosures = new LinkedList<Closure>();
    private GroovyWorld world;
    private Glue glue;

    GroovyBackend(Lookup lookup, Container container, Supplier<ClassLoader> classLoaderSupplier) {
        this.lookup = lookup;
        this.container = container;
        this.shell = this.createShell();
        this.resourceLoader = new ResourceScanner(classLoaderSupplier, GroovyScriptIdentifier::isGroovyScript, resource -> GroovyScriptIdentifier.parse(resource, this.shell));
        this.classFinder = new ClasspathScanner(classLoaderSupplier);
        instanceThreadLocal.set(this);
    }

    static GroovyBackend getInstance() {
        return instanceThreadLocal.get();
    }

    private GroovyShell createShell() {
        CompilerConfiguration compilerConfig = new CompilerConfiguration();
        return new GroovyShell(this.getClass().getClassLoader(), new Binding(), compilerConfig);
    }

    public void loadGlue(Glue glue, List<URI> gluePaths) {
        this.glue = glue;
        Binding context = this.shell.getContext();
        gluePaths.stream().map(arg_0 -> this.resourceLoader.scanForResourcesUri(arg_0)).flatMap(Collection::stream).forEach(script -> this.runIfScript(context, (Script)script));
        gluePaths.stream().filter(gluePath -> "classpath".equals(gluePath.getScheme())).map(ClasspathSupport::packageName).map(c -> this.classFinder.scanForSubClassesInPackage(c, Script.class)).flatMap(Collection::stream).forEach(glueClass -> {
            Script script;
            try {
                script = (Script)glueClass.getConstructor(Binding.class).newInstance(context);
            }
            catch (Exception e) {
                throw new CucumberException((Throwable)e);
            }
            this.runIfScript(context, script);
        });
    }

    private void registerParameters(Class scriptClass) {
        MethodScanner.scan(scriptClass, (method, annotation) -> {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType.equals(ParameterType.class)) {
                ParameterType parameterType = (ParameterType)annotation;
                String pattern = parameterType.value();
                String name = parameterType.name();
                boolean useForSnippets = parameterType.useForSnippets();
                boolean preferForRegexMatch = parameterType.preferForRegexMatch();
                this.glue.addParameterType((ParameterTypeDefinition)new GroovyParameterTypeDefinition(name, pattern, (Method)method, useForSnippets, preferForRegexMatch, this.lookup));
            } else if (annotationType.equals(DataTableType.class)) {
                DataTableType dataTableType = (DataTableType)annotation;
                this.glue.addDataTableType((DataTableTypeDefinition)new GroovyDataTableTypeDefinition((Method)method, this.lookup, dataTableType.replaceWithEmptyString()));
            } else if (annotationType.equals(DefaultParameterTransformer.class)) {
                this.glue.addDefaultParameterTransformer((DefaultParameterTransformerDefinition)new GroovyDefaultParameterTransformerDefinition((Method)method, this.lookup));
            } else if (annotationType.equals(DefaultDataTableEntryTransformer.class)) {
                DefaultDataTableEntryTransformer transformer = (DefaultDataTableEntryTransformer)annotation;
                boolean headersToProperties = transformer.headersToProperties();
                String[] replaceWithEmptyString = transformer.replaceWithEmptyString();
                this.glue.addDefaultDataTableEntryTransformer((DefaultDataTableEntryTransformerDefinition)new GroovyDefaultDataTableEntryTransformerDefinition((Method)method, this.lookup, headersToProperties, replaceWithEmptyString));
            } else if (annotationType.equals(DefaultDataTableCellTransformer.class)) {
                DefaultDataTableCellTransformer cellTransformer = (DefaultDataTableCellTransformer)annotation;
                String[] emptyPatterns = cellTransformer.replaceWithEmptyString();
                this.glue.addDefaultDataTableCellTransformer((DefaultDataTableCellTransformerDefinition)new GroovyDefaultDataTableCellTransformerDefinition((Method)method, this.lookup, emptyPatterns));
            } else if (annotationType.equals(DocStringType.class)) {
                DocStringType docStringType = (DocStringType)annotation;
                String contentType = docStringType.contentType();
                this.glue.addDocStringType((DocStringTypeDefinition)new GroovyDocStringTypeDefinition(contentType, (Method)method, this.lookup));
            }
        });
    }

    private void runIfScript(Binding context, Script script) {
        Class scriptClass = script.getMetaClass().getTheClass();
        if (GroovyScriptIdentifier.isScript(script) && !this.scripts.contains(scriptClass)) {
            script.setBinding(context);
            this.registerParameters(scriptClass);
            script.run();
            this.scripts.add(scriptClass);
            this.container.addClass(scriptClass);
        }
    }

    public void buildWorld() {
        this.world = new GroovyWorld();
        for (Closure closure : this.worldClosures) {
            this.world.registerWorld(closure.call());
        }
    }

    public void disposeWorld() {
        this.world = null;
    }

    public Snippet getSnippet() {
        return new GroovySnippet();
    }

    void registerWorld(Closure closure) {
        this.worldClosures.add(closure);
    }

    void addStepDefinition(String regexp, Closure body) {
        this.glue.addStepDefinition((StepDefinition)new GroovyStepDefinition(regexp, body, GroovyScriptIdentifier.currentLocation(), this));
    }

    void addBeforeHook(String tagPredicate, int order, Closure body) {
        this.glue.addBeforeHook((HookDefinition)new GroovyHookDefinition(tagPredicate, order, body, GroovyScriptIdentifier.currentLocation(), this));
    }

    void addAfterHook(String tagPredicate, int order, Closure body) {
        this.glue.addAfterHook((HookDefinition)new GroovyHookDefinition(tagPredicate, order, body, GroovyScriptIdentifier.currentLocation(), this));
    }

    void addBeforeStepHook(String tagPredicate, int order, Closure body) {
        this.glue.addBeforeStepHook((HookDefinition)new GroovyHookDefinition(tagPredicate, order, body, GroovyScriptIdentifier.currentLocation(), this));
    }

    void addAfterStepHook(String tagPredicate, int order, Closure body) {
        this.glue.addAfterStepHook((HookDefinition)new GroovyHookDefinition(tagPredicate, order, body, GroovyScriptIdentifier.currentLocation(), this));
    }

    GroovyWorld getGroovyWorld() {
        return this.world;
    }
}

