/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import io.cucumber.core.backend.DataTableTypeDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.datatable.DataTable;
import io.cucumber.groovy.AbstractDatatableElementTransformerDefinition;
import io.cucumber.groovy.DataTableType;
import io.cucumber.groovy.InvalidMethodSignatureException;
import io.cucumber.groovy.Invoker;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

class GroovyDataTableTypeDefinition
extends AbstractDatatableElementTransformerDefinition
implements DataTableTypeDefinition {
    private final io.cucumber.datatable.DataTableType dataTableType;

    GroovyDataTableTypeDefinition(Method method, Lookup lookup, String[] emptyPatterns) {
        super(method, lookup, emptyPatterns);
        this.dataTableType = this.createDataTableType(method);
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(DataTableType.class).addSignature("Author author(DataTable table)").addSignature("Author author(List<String> row)").addSignature("Author author(Map<String, String> entry)").addSignature("Author author(String cell)").addNote("Note: Author is an example of the class you want to convert the table to.").build();
    }

    private static Type requireValidParameterType(Method method) {
        Type[] typeParameters;
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length != 1) {
            throw GroovyDataTableTypeDefinition.createInvalidSignatureException(method);
        }
        Type parameterType = parameterTypes[0];
        if (!(parameterType instanceof ParameterizedType)) {
            return parameterType;
        }
        ParameterizedType parameterizedType = (ParameterizedType)parameterType;
        for (Type typeParameter : typeParameters = parameterizedType.getActualTypeArguments()) {
            if (String.class.equals((Object)typeParameter)) continue;
            throw GroovyDataTableTypeDefinition.createInvalidSignatureException(method);
        }
        return parameterizedType.getRawType();
    }

    private static Type requireValidReturnType(Method method) {
        Type returnType = method.getGenericReturnType();
        if (Void.class.equals((Object)returnType) || Void.TYPE.equals(returnType)) {
            throw GroovyDataTableTypeDefinition.createInvalidSignatureException(method);
        }
        return returnType;
    }

    private io.cucumber.datatable.DataTableType createDataTableType(Method method) {
        Type returnType = GroovyDataTableTypeDefinition.requireValidReturnType(method);
        Type parameterType = GroovyDataTableTypeDefinition.requireValidParameterType(method);
        if (DataTable.class.equals((Object)parameterType)) {
            return new io.cucumber.datatable.DataTableType(returnType, table -> this.execute(this.replaceEmptyPatternsWithEmptyString(table)));
        }
        if (List.class.equals((Object)parameterType)) {
            return new io.cucumber.datatable.DataTableType(returnType, row -> this.execute(this.replaceEmptyPatternsWithEmptyString(row)));
        }
        if (Map.class.equals((Object)parameterType)) {
            return new io.cucumber.datatable.DataTableType(returnType, entry -> this.execute(this.replaceEmptyPatternsWithEmptyString(entry)));
        }
        if (String.class.equals((Object)parameterType)) {
            return new io.cucumber.datatable.DataTableType(returnType, cell -> this.execute(this.replaceEmptyPatternsWithEmptyString(cell)));
        }
        throw GroovyDataTableTypeDefinition.createInvalidSignatureException(method);
    }

    public io.cucumber.datatable.DataTableType dataTableType() {
        return this.dataTableType;
    }

    private Object execute(Object arg) {
        return Invoker.invoke(this, this.lookup.getInstance(this.method.getDeclaringClass()), this.method, arg);
    }
}

