/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import io.cucumber.core.backend.DefaultDataTableCellTransformerDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.datatable.TableCellByTypeTransformer;
import io.cucumber.groovy.AbstractDatatableElementTransformerDefinition;
import io.cucumber.groovy.DefaultDataTableCellTransformer;
import io.cucumber.groovy.InvalidMethodSignatureException;
import io.cucumber.groovy.Invoker;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class GroovyDefaultDataTableCellTransformerDefinition
extends AbstractDatatableElementTransformerDefinition
implements DefaultDataTableCellTransformerDefinition {
    private final TableCellByTypeTransformer transformer = (cellValue, toValueType) -> this.execute(this.replaceEmptyPatternsWithEmptyString(cellValue), toValueType);

    GroovyDefaultDataTableCellTransformerDefinition(Method method, Lookup lookup, String[] emptyPatterns) {
        super(GroovyDefaultDataTableCellTransformerDefinition.requireValidMethod(method), lookup, emptyPatterns);
    }

    private static Method requireValidMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        if (Void.class.equals(returnType) || Void.TYPE.equals(returnType)) {
            throw GroovyDefaultDataTableCellTransformerDefinition.createInvalidSignatureException(method);
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 2) {
            throw GroovyDefaultDataTableCellTransformerDefinition.createInvalidSignatureException(method);
        }
        if (!Object.class.equals(parameterTypes[0]) && !String.class.equals(parameterTypes[0])) {
            throw GroovyDefaultDataTableCellTransformerDefinition.createInvalidSignatureException(method);
        }
        if (!Type.class.equals(parameterTypes[1])) {
            throw GroovyDefaultDataTableCellTransformerDefinition.createInvalidSignatureException(method);
        }
        return method;
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(DefaultDataTableCellTransformer.class).addSignature("Object defaultDataTableCell(String fromValue, Type toValueType)").addSignature("Object defaultDataTableCell(Object fromValue, Type toValueType)").build();
    }

    public TableCellByTypeTransformer tableCellByTypeTransformer() {
        return this.transformer;
    }

    private Object execute(String fromValue, Type toValueType) {
        return Invoker.invoke(this, this.lookup.getInstance(this.method.getDeclaringClass()), this.method, fromValue, toValueType);
    }
}

