/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import io.cucumber.core.backend.DefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.datatable.TableCellByTypeTransformer;
import io.cucumber.datatable.TableEntryByTypeTransformer;
import io.cucumber.groovy.AbstractDatatableElementTransformerDefinition;
import io.cucumber.groovy.DefaultDataTableEntryTransformer;
import io.cucumber.groovy.InvalidMethodSignatureException;
import io.cucumber.groovy.Invoker;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

class GroovyDefaultDataTableEntryTransformerDefinition
extends AbstractDatatableElementTransformerDefinition
implements DefaultDataTableEntryTransformerDefinition {
    private final TableEntryByTypeTransformer transformer;
    private final boolean headersToProperties;

    GroovyDefaultDataTableEntryTransformerDefinition(Method method, Lookup lookup) {
        this(method, lookup, false, new String[0]);
    }

    GroovyDefaultDataTableEntryTransformerDefinition(Method method, Lookup lookup, boolean headersToProperties, String[] emptyPatterns) {
        super(GroovyDefaultDataTableEntryTransformerDefinition.requireValidMethod(method), lookup, emptyPatterns);
        this.headersToProperties = headersToProperties;
        this.transformer = (entryValue, toValueType, cellTransformer) -> this.execute(this.replaceEmptyPatternsWithEmptyString(entryValue), toValueType, cellTransformer);
    }

    private static Method requireValidMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        if (Void.class.equals(returnType) || Void.TYPE.equals(returnType)) {
            throw GroovyDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length < 2 || parameterTypes.length > 3) {
            throw GroovyDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
        }
        Type parameterType = genericParameterTypes[0];
        if (!Object.class.equals((Object)parameterType)) {
            Type[] typeParameters;
            if (!(parameterType instanceof ParameterizedType)) {
                throw GroovyDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
            }
            ParameterizedType parameterizedType = (ParameterizedType)parameterType;
            Type rawType = parameterizedType.getRawType();
            if (!Map.class.equals((Object)rawType)) {
                throw GroovyDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
            }
            for (Type typeParameter : typeParameters = parameterizedType.getActualTypeArguments()) {
                if (String.class.equals((Object)typeParameter)) continue;
                throw GroovyDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
            }
        }
        if (!Type.class.equals(parameterTypes[1])) {
            throw GroovyDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
        }
        if (parameterTypes.length == 3 && !Object.class.equals(parameterTypes[2]) && !TableCellByTypeTransformer.class.equals(parameterTypes[2])) {
            throw GroovyDefaultDataTableEntryTransformerDefinition.createInvalidSignatureException(method);
        }
        return method;
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(DefaultDataTableEntryTransformer.class).addSignature("Object defaultDataTableEntry(Map<String, String> fromValue, Type toValueType)").addSignature("Object defaultDataTableEntry(Object fromValue, Type toValueType)").build();
    }

    public TableEntryByTypeTransformer tableEntryByTypeTransformer() {
        return this.transformer;
    }

    public boolean headersToProperties() {
        return this.headersToProperties;
    }

    private Object execute(Map<String, String> fromValue, Type toValueType, TableCellByTypeTransformer cellTransformer) {
        Object[] args = this.method.getParameterTypes().length == 3 ? new Object[]{fromValue, toValueType, cellTransformer} : new Object[]{fromValue, toValueType};
        return Invoker.invoke(this, this.lookup.getInstance(this.method.getDeclaringClass()), this.method, args);
    }
}

