/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import io.cucumber.core.backend.DefaultParameterTransformerDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.cucumberexpressions.ParameterByTypeTransformer;
import io.cucumber.groovy.AbstractParamGlueDefinition;
import io.cucumber.groovy.DefaultParameterTransformer;
import io.cucumber.groovy.InvalidMethodSignatureException;
import io.cucumber.groovy.Invoker;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class GroovyDefaultParameterTransformerDefinition
extends AbstractParamGlueDefinition
implements DefaultParameterTransformerDefinition {
    private final Lookup lookup;
    private final ParameterByTypeTransformer transformer;

    GroovyDefaultParameterTransformerDefinition(Method method, Lookup lookup) {
        super(GroovyDefaultParameterTransformerDefinition.requireValidMethod(method), lookup);
        this.lookup = lookup;
        this.transformer = this::execute;
    }

    private static Method requireValidMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        if (Void.class.equals(returnType) || Void.TYPE.equals(returnType)) {
            throw GroovyDefaultParameterTransformerDefinition.createInvalidSignatureException(method);
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 2) {
            throw GroovyDefaultParameterTransformerDefinition.createInvalidSignatureException(method);
        }
        if (!Object.class.equals(parameterTypes[0]) && !String.class.equals(parameterTypes[0])) {
            throw GroovyDefaultParameterTransformerDefinition.createInvalidSignatureException(method);
        }
        if (!Type.class.equals(parameterTypes[1])) {
            throw GroovyDefaultParameterTransformerDefinition.createInvalidSignatureException(method);
        }
        return method;
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(DefaultParameterTransformer.class).addSignature("Object defaultDataTableEntry(String fromValue, Type toValueType)").addSignature("Object defaultDataTableEntry(Object fromValue, Type toValueType)").build();
    }

    public ParameterByTypeTransformer parameterByTypeTransformer() {
        return this.transformer;
    }

    private Object execute(String fromValue, Type toValueType) {
        return Invoker.invoke(this, this.lookup.getInstance(this.method.getDeclaringClass()), this.method, fromValue, toValueType);
    }
}

