/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import io.cucumber.core.backend.DocStringTypeDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.groovy.AbstractParamGlueDefinition;
import io.cucumber.groovy.DocStringType;
import io.cucumber.groovy.InvalidMethodSignatureException;
import io.cucumber.groovy.Invoker;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class GroovyDocStringTypeDefinition
extends AbstractParamGlueDefinition
implements DocStringTypeDefinition {
    private final io.cucumber.docstring.DocStringType docStringType;

    GroovyDocStringTypeDefinition(String contentType, Method method, Lookup lookup) {
        super(GroovyDocStringTypeDefinition.requireValidMethod(method), lookup);
        this.docStringType = new io.cucumber.docstring.DocStringType(this.method.getReturnType(), contentType.isEmpty() ? method.getName() : contentType, this::execute);
    }

    private static Method requireValidMethod(Method method) {
        Type returnType = method.getGenericReturnType();
        if (Void.class.equals((Object)returnType) || Void.TYPE.equals(returnType)) {
            throw GroovyDocStringTypeDefinition.createInvalidSignatureException(method);
        }
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length != 1) {
            throw GroovyDocStringTypeDefinition.createInvalidSignatureException(method);
        }
        for (Type parameterType : parameterTypes) {
            if (String.class.equals((Object)parameterType)) continue;
            throw GroovyDocStringTypeDefinition.createInvalidSignatureException(method);
        }
        return method;
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(DocStringType.class).addSignature("JsonNode json(String content)").addNote("Note: JsonNode is an example of the class you want to convert content to").build();
    }

    private Object execute(String content) {
        return Invoker.invoke(this, this.lookup.getInstance(this.method.getDeclaringClass()), this.method, content);
    }

    public io.cucumber.docstring.DocStringType docStringType() {
        return this.docStringType;
    }
}

