/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.ParameterTypeDefinition;
import io.cucumber.groovy.AbstractParamGlueDefinition;
import io.cucumber.groovy.InvalidMethodSignatureException;
import io.cucumber.groovy.Invoker;
import io.cucumber.groovy.ParameterType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;

class GroovyParameterTypeDefinition
extends AbstractParamGlueDefinition
implements ParameterTypeDefinition {
    private final io.cucumber.cucumberexpressions.ParameterType<Object> parameterType;

    GroovyParameterTypeDefinition(String name, String pattern, Method method, boolean useForSnippets, boolean preferForRegexpMatch, Lookup lookup) {
        super(GroovyParameterTypeDefinition.requireValidMethod(method), lookup);
        this.parameterType = new io.cucumber.cucumberexpressions.ParameterType(name.isEmpty() ? method.getName() : name, Collections.singletonList(pattern), this.method.getGenericReturnType(), this::execute, useForSnippets, preferForRegexpMatch);
    }

    private static Method requireValidMethod(Method method) {
        Type returnType = method.getGenericReturnType();
        if (Void.class.equals((Object)returnType) || Void.TYPE.equals(returnType)) {
            throw GroovyParameterTypeDefinition.createInvalidSignatureException(method);
        }
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length == 0) {
            throw GroovyParameterTypeDefinition.createInvalidSignatureException(method);
        }
        if (parameterTypes.length == 1) {
            if (!String.class.equals((Object)parameterTypes[0]) && !String[].class.equals((Object)parameterTypes[0])) {
                throw GroovyParameterTypeDefinition.createInvalidSignatureException(method);
            }
            return method;
        }
        for (Type parameterType : parameterTypes) {
            if (String.class.equals((Object)parameterType)) continue;
            throw GroovyParameterTypeDefinition.createInvalidSignatureException(method);
        }
        return method;
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(ParameterType.class).addSignature("public Author parameterName(String all)").addSignature("public Author parameterName(String captureGroup1, String captureGroup2, ...ect )").addSignature("public Author parameterName(String... captureGroups)").addNote("Note: Author is an example of the class you want to convert captureGroups to").build();
    }

    public io.cucumber.cucumberexpressions.ParameterType<?> parameterType() {
        return this.parameterType;
    }

    private Object execute(String[] captureGroups) {
        Object args = String[].class.equals(this.method.getParameterTypes()[0]) ? new Object[][]{captureGroups} : captureGroups;
        return Invoker.invoke(this, this.lookup.getInstance(this.method.getDeclaringClass()), this.method, args);
    }
}

