/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.groovy;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import io.cucumber.core.resource.Resource;
import io.cucumber.groovy.ScriptPath;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class GroovyScriptIdentifier {
    private static final String GROOVY_FILE_SUFFIX = ".groovy";

    private GroovyScriptIdentifier() {
    }

    public static URI parse(String groovyIdentifier) {
        return GroovyScriptIdentifier.parse(ScriptPath.parse(groovyIdentifier));
    }

    public static URI parse(URI groovyIdentifier) {
        if (!GroovyScriptIdentifier.isGroovyScript(groovyIdentifier)) {
            throw new IllegalArgumentException("Groovy identifier does not reference a single groovy file: " + groovyIdentifier);
        }
        return groovyIdentifier;
    }

    public static boolean isGroovyScript(URI groovyIdentifier) {
        return groovyIdentifier.getSchemeSpecificPart().endsWith(GROOVY_FILE_SUFFIX);
    }

    public static boolean isGroovyScript(Path path) {
        return path.getFileName().toString().endsWith(GROOVY_FILE_SUFFIX);
    }

    public static StackTraceElement currentLocation() {
        StackTraceElement[] stackTraceElements;
        Throwable t = new Throwable();
        for (StackTraceElement stackTraceElement : stackTraceElements = t.getStackTrace()) {
            if (!GroovyScriptIdentifier.isGroovyFile(stackTraceElement.getFileName())) continue;
            return stackTraceElement;
        }
        throw new RuntimeException("Couldn't find location for step definition");
    }

    public static boolean isGroovyFile(String fileName) {
        return fileName != null && fileName.endsWith(GROOVY_FILE_SUFFIX);
    }

    public static boolean isScript(Script script) {
        return DefaultGroovyMethods.asBoolean((Collection)script.getMetaClass().respondsTo((Object)script, "main"));
    }

    public static Optional<Script> parse(Resource resource, GroovyShell shell) {
        try {
            return Optional.of(shell.parse((Reader)new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

